<?php
/**
 * Copyright 2002 by Jeroen Baten
 *
 * version 1.0: Initial version by Jeroen Baten
 *
 * @modulegroup note
 * @module note_new
 * @package note
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");

 include 'webelements.p3' ;
 include 'permission.p3' ;

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("merge","new");
 loadmodule("merge");
 loadmodule("group");
 loadlayout();

 /**
  * intitialize a merge
  */
 class merge_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang,$tutos;

	 $this->addHidden("gotourl","merge/merge_new.php");
	 $this->addHidden("link_id",$this->obj->link_id);

     echo "<form name=\"mergenew\" action=\"merge_ins.php\" method=\"POST\">";
	 echo $this->DataTableStart();

     echo "<tr><th colspan=\"2\">". $this->obj->ref->getFullName()." ".$lang['MergeWith']."</th></tr>\n\n";
     echo "<tr>\n";
     echo " <td> <input type='radio' checked='' name='merge_with' value='current'></td>\n";
     echo " <td nowrap>".$lang['CurrentContact']."</td>\n";
     echo "</tr><tr>\n";
     echo "  <td> <input type='radio' disabled=''  name='merge_with' value='lookup'></td>\n";
     echo "  <td nowrap>".$lang['CurrentLookup']."</td>\n";
     echo "</tr><tr>\n";
     echo "  <td> <input type='radio'  name='merge_with' value='all'></td>\n";
     echo "  <td nowrap>".$lang['AllContacts']."</td>\n";
     echo "</tr>";

     # start group selection part. If one has read rights I suppose the
     # module is present....?
     if (  defined('usegroup') && $this->user->feature_ok(usegroup,PERM_SEE) ) {
       echo "   <tr>\n";
       echo "     <td> <input type='radio' name='merge_with' value='group'></td>\n";
       echo "     <td nowrap>".$lang['SelectedGroup']."</td>\n";
       echo "   </tr><tr>\n";
       echo "     <td>&nbsp;</td>\n";
       echo "     <td nowrap><select multiple=''  name='groupname'>\n";
       echo "          <option name='group1'>group 1</option>\n";
       echo "         </select></td>\n";
       echo "   </tr>";
       # end group selection part
     }
   
     echo "<tr>";
     echo $this->showfield($lang['Template'],1,"template");
     echo "<td>\n";
     echo "<select size=\"6\" name='template'>\n";
     # read all template files and display them
     show_templates($this->obj->send_to);
     echo "</select></td>\n";
 
     echo "</tr><tr>\n";

     echo $this->showfield($lang['SendOutputTo'],1,"send_to");
     echo " <td>\n";

     echo "<input type=\"radio\" ". ( $this->obj->send_to== "printer" ? "checked=''" : "disabled=''") ;
     echo " name='send_to' value='printer'>\n";
     echo makelink("merge_new.php?link_id=". $this->obj->link_id."&send_to=printer" ,$lang['Printer']) ."\n";

     echo "<br>\n";

     echo "<input type=\"radio\" ". ( $this->obj->send_to=="email" ? "checked=''" : "disabled=''");
     echo " name='send_to' value='email'>\n";
     echo  makelink("merge_new.php?link_id=". $this->obj->link_id."&send_to=email" ,$lang['Email']) ."\n";

     echo "<br>\n";

     echo "<input type='radio' ". ( $this->obj->send_to=='fax' ? "checked=''" : "disabled=''");
     echo " name='send_to' value='fax'>\n";
     echo  makelink("merge_new.php?link_id=". $this->obj->link_id."&send_to=fax" ,$lang['Fax'])."\n";

     echo "<br>\n";

     echo "<input type='radio' ". ( $this->obj->send_to=='wordprocessor' ? "checked=''" : "disabled=''");
     echo " name='send_to' value='wordprocessor'>\n";
     echo makelink("merge_new.php?link_id=". $this->obj->link_id."&send_to=wordprocessor" ,$lang['WordProcessor'])."\n";

     echo "<br>\n";

     echo "<input type='radio'". ( $this->obj->send_to=='null' ? "checked=''" : "disabled=''");
     echo " name='send_to' value='null'>\n";
     echo makelink("merge_new.php?link_id=". $this->obj->link_id."&send_to=null" ,$lang['Nowhere'])."</td>\n";

     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfield($lang['ReturnReceipt'],0,"returnreceipt");
     echo "<td> <input type='checkbox'  name='returnreceipt' value='yes'></td>\n";

     echo "</tr><tr>\n";

     echo $this->showfield($lang['AttachToContacts'],0,"attachcontacts");
     echo "<td> <input type='checkbox'  name='attachcontacts' value='yes'></td>\n";

     echo "</tr><tr>\n";

     echo $this->showfield($lang['AddCompanyHistory'],0,"archive");
     echo "<td> <input type='checkbox' checked='' name='archive' value='yes'></td>\n";

     echo "</tr><tr>\n";

     echo $this->showfield($lang['Regarding'],0,"regarding");
     echo "<td><input type='text' name='regarding'></td>\n";

     echo "</tr>\n";

	 $this->addHidden("action","merge");
     echo "<tr><td><input type='submit' value='".$lang['Merge']."'></td></tr>\n";

     echo $this->DataTableEnd();

     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
   }
   /**
    *
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $lang,$tutos;

     $this->name = $lang['MergeDocuments'];
     $this->obj = new merge($this->dbconn);

     if ( isset($_GET['link_id']) ){
       $this->obj->link_id = $_GET['link_id'];
     }
     if ( isset($_GET['template']) ){
       $this->obj->template = $_GET['template'];
     }
     if ( isset($_GET['merge_with']) ){
       $this->obj->merge_with = $_GET['merge_with'];
     }
     if ( isset($_GET['returnreceipt']) ){
       $this->obj->returnreceipt = $_GET['returnreceipt'];
     }
     if ( isset($_GET['attachcontacts']) ){
       $this->obj->attachcontacts = $_GET['attachcontacts'];
     }
     if ( isset($_GET['archive']) ){
       $this->obj->archive = $_GET['archive'];
     }
     if ( isset($_GET['regarding']) ){
       $this->obj->regarding = $_GET['regarding'];
     }
     if ( isset($_GET['send_to']) ) {
       $this->obj->send_to= $_GET['send_to'];
     } else {
       $this->obj->send_to='wordprocessor';
     }

     $this->obj->read_reference();
   }
 }


 $l = new merge_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: merge_new.php,v 1.7 2003/02/07 05:22:22 gokohnert Exp $
    $Author: gokohnert $
-->
