<?php
/**
 * Copyright 2002 - 2003 by Gero Kohnert
 *
 * show an invoice
 *
 * @modulegroup invoice
 * @module invoice_show
 * @package invoice
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("invoice","show");
 loadmodule("invoice");
 loadlayout();


 /* ---------------------------------------------------------------------------
  *
  */
 Function show_invpos(&$f) {
   global $lang;

   $f->read_ref();
   echo "<tr>\n";
   if ( $f->ref != -1 ) {
     echo " <td align=\"right\" valign=\"top\">". $f->ref->getLink(sprintf("%04d",$f->pos)) ."</td>";
   } else {
     echo " <td align=\"right\" valign=\"top\">". sprintf("%04d",$f->pos) ."</td>";
   }
   echo " <td align=\"right\" valign=\"top\">".  number_format($f->items,2,$lang['DecPoint'],$lang['ThousandPoint']) ."&nbsp;</td>";
   echo " <td align=\"right\" valign=\"top\">". $f->itype ."&nbsp;</td>";
   echo " <td valign=\"top\"><pre>". $f->description ."</pre></td>";
   echo " <td align=\"right\" valign=\"top\">".  number_format($f->sum_single ,2,$lang['DecPoint'],$lang['ThousandPoint']) ."</td>";
   echo " <td align=\"right\" valign=\"top\">".  number_format($f->tax ,2,$lang['DecPoint'],$lang['ThousandPoint']) ."</td>";
   echo " <td align=\"right\" valign=\"top\">". number_format($f->getTotal(),2,$lang['DecPoint'],$lang['ThousandPoint']) ."</td>";
   echo " <td align=\"left\" valign=\"top\">&nbsp;". $f->currency ."</td>";
   echo "</tr>\n";
 }

 /**
  * display a invoice
  */
 class invoice_show extends layout {
   /**
    * the data display part
    */
   Function info() {
     global $tutos,$lang;

      if ( $this->format == "pdf" ) {
       $data = $this->obj->getPDF();
       Header("Content-Type: application/pdf");
       Header("Content-Disposition: inline; filename=\"". $this->obj->name ."pdf\"");
       Header('Content-length: ' . strlen($data));
       Header("Content-Description: Upload from TUTOS" );
       echo $data;
       return;
     }
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"8\">". sprintf($lang['Showing'],$lang[$this->obj->getType()]) ."</th>\n";
     echo "</tr>\n";
     echo "<tr>\n";
     echo " <td colspan=\"8\">". $lang['createdby'] ." ". $this->obj->creator->getLink();
     echo " ". $lang['atDateTime'] ." ". $this->obj->creation->getLinkDateTime() ."</td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['Accountant']);
     if ( $this->obj->acc->getType() == "location" ) {
       echo "<td colspan=\"7\">". $this->obj->acc->company->getLink() ."</td>\n";
     } else {
       echo "<td colspan=\"7\">". $this->obj->acc->getLink() ."</td>\n";
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['InvoiceName']);
     echo $this->showdata(myentities($this->obj->name),3);
     echo $this->showfieldc($lang['InvoiceState']);
     echo $this->showdata($lang['InvoiceStates'][$this->obj->state],3);
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['InvoiceCustomer']);
     if (is_object($this->obj->customer) ) {
       echo $this->showdata($this->obj->customer->getLink(),7);
     } else {
       echo $this->showdata($lang['HistoryDeleted'],7);
     }
     echo "</tr>\n";

     if ( $this->obj->ref != -1 ) {
       echo "<tr>\n";
       echo $this->showfieldc($lang[$this->obj->ref->getType()],0);
       echo $this->showdata($this->obj->ref->getLink(),7);
       echo "</tr>\n";
     }

     if ( ($this->obj->datesent[0]->notime != 1) or ($this->obj->datedue[0]->notime != 1) ) {
       echo "<tr>\n";
       echo $this->showfieldc($lang['InvDateSent'][0]);
       echo $this->showdata($this->obj->datesent[0]->getDate(),3);
       echo $this->showfieldc($lang['InvDateDue'][0]);
       echo $this->showdata($this->obj->datedue[0]->getDate(),3);
       echo "</tr>\n";
     }

     if ( $this->obj->datesent[1]->notime != 1 ) {
       echo "<tr>\n";
       echo $this->showfieldc($lang['InvDateSent'][1]);
       echo $this->showdata($this->obj->datesent[1]->getDate(),3);
       echo $this->showfieldc($lang['InvDateDue'][1]);
       echo $this->showdata($this->obj->datedue[1]->getDate(),3);
       echo "</tr>\n";
     }

     if ( $this->obj->datesent[2]->notime != 1 ) {
       echo "<tr>\n";
       echo $this->showfieldc($lang['InvDateSent'][2]);
       echo $this->showdata($this->obj->datesent[2]->getDate(),3);
       echo $this->showfieldc($lang['InvDateDue'][2]);
       echo $this->showdata($this->obj->datedue[2]->getDate(),3);
       echo "</tr>\n";
     }
     if ( $this->obj->state == INV_STATE_PAYED ) {
       echo "<tr>\n";
       echo $this->showfieldc($lang['InvDatePayed']);
       echo $this->showdata($this->obj->datefinish->getDate(),7);
       echo "</tr>\n";
     }
     if ( $this->obj->state == INV_STATE_CANCELLED ) {
       echo "<tr>\n";
       echo $this->showfieldc($lang['InvDateCancel']);
       echo $this->showdata($this->obj->datefinish->getDate(),7);
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo "<th>". $lang['InvPosPos'] ."</th>\n";
     echo "<th>". $lang['InvPosItems'] ."</th>\n";
     echo "<th>". $lang['InvPosIType'] ."</th>\n";
     echo "<th>". $lang['InvPosDesc'] ."</th>\n";
     echo "<th>". $lang['InvPosSingle'] ."</th>\n";
     echo "<th>". $lang['InvPosTax'] ."</th>\n";
     echo "<th>". $lang['InvPosSum'] ."</th>\n";
     echo "<th>". $lang['Currency'] ."</th>\n";
     echo "</tr>\n";
   
     if ( count($this->obj->pos) == 0 ) {
       echo "<tr>\n";
       echo "<td colspan=\"8\" class=\"warn\">".$lang['Err0048']."</td>\n";
       echo "</tr>\n";
     }
     $sum = $this->obj->getTotal();
     foreach ($this->obj->pos as $f) {
       show_invpos($f);
       unset($f);
     }
     echo "<tr>";
     echo "<td colspan=\"6\">&nbsp;</td>\n";
     echo "<td colspan=\"2\" align=\"right\">&nbsp;<b>";
     $pre = "";
     foreach($sum as $cur => $val) {
       if ( $val != 0 ) {
         $x = array($val,$cur);
         echo $pre . handle('money',$x,number_format($val,2,$lang['DecPoint'],$lang['ThousandPoint']) ."&nbsp;". $cur);
         $pre = "<br>\n";
       }
     }
     echo  "</b></td>\n";
     echo "</tr>";

     # References to modules
     show_module_infolists($this->user,$this->obj,8,$this->format);
     echo $this->obj->getHistoryLink(8);
     echo $this->DataTableEnd();
   }
   /**
    * navigate
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang, $tutos;

     $this->name = $lang['Invoice'];
     $this->obj = new invoice($this->dbconn);
     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
     }
     if ( ! $this->obj->see_ok() ) {
       $msg .= sprintf($lang['Err0022'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( $this->obj->id < 0 ) {
       $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else {
       $this->name .= ": ". $this->obj->getFullName();
       $this->obj->read_pos();
       $this->obj->read_ref();
     }
     # menu
     $m = invoice::getSelectLink($this->user,$lang['Search']);
     $this->addmenu($m);
     add_module_addlinks($this,$this->obj);

     if ( ($this->obj->id > 0) && $this->obj->mod_ok() ) {
       $x = array( url => "invoice/invoice_new.php?id=". $this->obj->id,
                   text => $lang['Modify'],
                   info => sprintf($lang['InvModInfo'],$this->obj->getFullname()),
                   category => array("invoice","mod","obj")
                 );
       $this->addMenu($x);
     }

     if ( ($this->obj->id > 0) && $this->obj->see_ok()  && function_exists( 'pdf_open_file') ) {
       $x = array( url => $this->obj->getUrl()  ."&amp;format=pdf",
                   text => $lang['InvDocument'],
                   info => $lang['InvDocumentI'],
                   category => array("invoice","show","obj")
                 );
       $this->addMenu($x);
     }

     # add this page to the browsehistory of the users session
     $this->addtohistory();
   }
 }



 $l = new invoice_show($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: invoice_show.php,v 1.24.2.1 2003/07/31 17:56:14 gokohnert Exp $
    $Author: gokohnert $
-->