<?php
/**
 * Copyright 2002 - 2003 by Gero Kohnert
 *
 * create a new invoice or modify an existing one
 *
 * @modulegroup invoice
 * @module invoice_new
 * @package invoice
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'bug.pinc';


 /* Check if user is allowed to use it */
 check_user();
 loadmodules("invoice","new");
 loadmodule("invoice");
 loadlayout();

 /* ---------------------------------------------------------------------------
  *
  */
 Function show_invpos(&$f,&$obj) {
   global $lang;

   echo "<tr>\n";
   if ( $f->id != -1 ) {
     if ( $f->ref != -1 ) {
       echo " <td valign=\"top\"><label for=\"del[]\">". $f->ref->getLink(sprintf("%04d",$f->pos)) ."</label></td>";
     } else {
       echo " <td valign=\"top\"><label for=\"del[]\">". sprintf("%04d",$f->pos) ."</label></td>";
     }
     if ( $obj->change_ok() ) {
       echo " <td valign=\"top\"><input name=\"I-". $f->id ."\" size=\"4\" value=\"". $f->items ."\"></td>";
     } else {
       echo " <td align=\"right\" valign=\"top\">".  number_format($f->items,2,$lang['DecPoint'],$lang['ThousandPoint']) ."&nbsp;</td>";
     }
     echo " <td valign=\"top\">". $f->itype ."</td>";
     if ( $obj->change_ok() ) {
       echo " <td valign=\"top\"><textarea name=\"D-". $f->id ."\" rows=\"3\" cols=\"20\">". $f->description ."</textarea></td>";
       echo " <td valign=\"top\"><input name=\"S-". $f->id ."\" type=\"text\" size=\"6\" value=\"". $f->sum_single ."\"></td>";
       echo " <td valign=\"top\">";
       TAX_select("T-".$f->id,$f->tax);
       echo " </td>";
     } else {
       echo " <td valign=\"top\"><pre>". $f->description ."</pre></td>";
       echo " <td align=\"right\" valign=\"top\">".  number_format($f->sum_single ,2,$lang['DecPoint'],$lang['ThousandPoint']) ."</td>";
       echo " <td align=\"right\" valign=\"top\">".  number_format($f->tax ,2,$lang['DecPoint'],$lang['ThousandPoint']) ."</td>";
     }
     echo " <td align=\"right\" valign=\"top\">". number_format($f->getTotal(),2,$lang['DecPoint'],$lang['ThousandPoint']) ."</td>";
     if ( $obj->change_ok() ) {
       echo " <td align=\"left\" valign=\"top\">\n";
       Currency_Select("C-".$f->id ,$f->currency);
       echo "</td>";
       echo " <td align=\"center\" valign=\"top\"><input type=\"checkbox\" name=\"del[]\" value=\"". $f->id ."\"></td>";
     } else {
       echo " <td align=\"left\" valign=\"top\">". $f->currency ."</td>";
       echo " <td align=\"center\" valign=\"top\">&nbsp;</td>";
     }
   } else {
     echo " <td valign=\"top\"><label for=\"add[]\">". $f->ref->getLink() ."</label></td>";
     echo " <td align=\"right\" valign=\"top\">".  number_format($f->items,2,$lang['DecPoint'],$lang['ThousandPoint']) ."&nbsp;</td>";
     echo " <td align=\"right\" valign=\"top\">". $f->itype ."&nbsp;</td>";
     echo " <td valign=\"top\"><pre>". $f->description ."</pre></td>";
     echo " <td align=\"right\" valign=\"top\">".  number_format($f->sum_single ,2,$lang['DecPoint'],$lang['ThousandPoint']) ."</td>";
     echo " <td valign=\"top\">&nbsp;</td>";
     echo " <td align=\"right\" valign=\"top\">". number_format($f->getTotal(),2,$lang['DecPoint'],$lang['ThousandPoint']) ."</td>";
     echo " <td align=\"left\" valign=\"top\">". $f->currency ."&nbsp;</td>";
     if ( is_object($f->ref) && ($f->ref->getType() == "timetrack") ) {
       echo " <td align=\"left\" valign=\"top\">\n";
       if ( $f->ref->state != 1 ) {
         echo $f->ref->getLink( $lang['TTState']." ".$lang['TTStates'][$f->ref->state]);
       } else {
         echo "<center><input type=\"checkbox\" name=\"add[]\" value=\"". $f->ref_id ."\"></center>";
       }
       if ( isset($f->ref->inv_id) && ($f->ref->inv_id != $obj->id) && ($f->ref->inv_id > 0)  ) {
         $f->ref->inv = new invoice($f->dbconn);
         $f->ref->inv->read($f->ref->inv_id);
         echo "&nbsp;". $f->ref->inv->getLink();
       }
     } else {
       echo "<td align=\"center\" valign=\"top\"><input type=\"checkbox\" name=\"add[]\" value=\"". $f->ref_id ."\">";
     }
     echo "</td>";
   }
   echo "</tr>\n";
 }
 /**
  * change/modify a invoice
  */
 class invoice_new extends layout {
   /**
    * display the form
    */
   Function info() {
     global $lang,$tutos,$table;

     echo "<form name=\"invadd\" action=\"invoice_ins.php\" method=\"post\">\n";
     if ($this->obj->id > 0 ) {
       $this->addHidden("id",$this->obj->id);
     }
     echo $this->DataTableStart();
     echo "<tr>\n";
     echo " <th colspan=\"9\">".  sprintf($lang['Showing'],$lang[$this->obj->getType()])."</th>\n";
     echo "</tr>\n";
     if ($this->obj->id > 0 ) {
       echo "<tr>\n";
       echo " <td colspan=\"5\">". sprintf ($lang['InvoiceCreation'],$this->obj->creator->getLink(),$this->obj->creation->getDateTime()) ."</td>\n";
       echo " <td colspan=\"4\" align=\"right\">". acl_link($this->obj) ."</td>\n";
       echo "</tr>\n";
     }

     echo "<tr>\n";
     echo $this->showfieldc($lang['Accountant'],1,"accountant");
     echo " <td colspan=\"8\">\n";
     if ( $this->obj->change_ok() ) {
       echo " <select name=\"accountant\">\n";
       $this->obj->creator->read_locs_data();
       echo " <option value=\"". $this->obj->creator->id ."\">". $this->obj->creator->getFullName() ."</option>\n";
       @reset($this->obj->creator->location);
       while ( list ($j,$l) = @each ($this->obj->creator->location) ) {
         if ( is_object($l->company) ) {
           echo " <option value=\"". $l->id ."\">". $l->company->getFullName() ."</option>\n";
         }
       }
       echo " </select>\n";
     } else {
       echo $this->obj->acc->getLink();
       $this->addHidden("accountant",$this->obj->accountant);
     }
     echo " </td>\n";
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['InvoiceName'],1,"name");
     echo "<td colspan=\"4\" valign=\"top\">\n";
     if ( $this->obj->change_ok() ) {
       if ( $this->obj->name == "auto" ) {
         echo "automatic";
         $this->addHidden("name",$this->obj->name);
       } else {
         echo " <input size=\"". min($table['invoice']['name'][size],30) ."\" maxlength=\"".$table['invoice']['name'][size]."\" name=\"name\" value=\"". $this->obj->name ."\">";
       }
     } else {
       echo $this->obj->getLink();
       $this->addHidden("name",$this->obj->name);
     }
     echo "</td>\n";
     echo $this->showfieldc($lang['InvoiceState'],1,"state");
     echo " <td colspan=\"3\">\n";
     echo " <select name=\"state\">\n";
     @reset($lang['InvoiceStates']);
     while ( list ($i,$f) = @each ($lang['InvoiceStates']) ) {
       echo " <option value=\"". $i ."\" ". ($i == $this->obj->state ? "SELECTED":"") .">". $f ."</option>\n";
     }
     echo " </select>\n";
     echo "</td></tr>\n";

     echo "<tr>\n";
     if ( is_object($this->obj->ref) ) {
       echo $this->showfieldc($lang[$this->obj->ref->getType()],0,"link_id");
       echo " <td colspan=\"8\" valign=\"top\">". $this->obj->ref->getLink() ."</td>";
       $this->addHidden("link_id",$this->obj->link_id);
     }
     echo "</tr>\n";

     echo "<tr>\n";
     echo $this->showfieldc($lang['InvoiceCustomer'],1,"cfn");
     echo " <td colspan=\"8\">\n";
     if ( $this->obj->change_ok() ) {
       select_from_array_or_input($this->obj,"c",$this->obj->customer,0);
     } else {
       if  (isset($this->obj->cutomer) && is_object($this->obj->customer) ) {
         echo $this->obj->customer->getLink();
       } else {
         select_from_array_or_input($this->obj,"c",$this->obj->customer,0);
       }
     }
     echo "</td></tr>\n";

     echo "<tr>\n";
     if ( ($this->obj->state == 1) or ($this->obj->state == 2) ) {
       echo $this->showfieldc($lang['InvDateSent'][0]);
       echo "<td colspan=\"4\">";
       $this->obj->datesent[0]->EnterDate("s0",1);
       echo "</td>";
       echo $this->showfieldc($lang['InvDateDue'][0]);
       echo "<td colspan=\"3\">";
       echo $this->obj->datedue[0]->EnterDate("d0",1);
       echo "</td>";
     } else {
       echo $this->showfieldc($lang['InvDateSent'][0]);
       echo $this->showdata($this->obj->datesent[0]->getDate(),4);
       echo $this->showfieldc($lang['InvDateDue'][0]);
       echo $this->showdata($this->obj->datedue[0]->getDate(),3);
     }
     echo "</tr>\n";

     # The existing positions in the invoice
     echo "<tr>\n";
     echo "<th colspan=\"9\">". $lang['InvExistingPos'] ."</th>\n";
     echo "</tr>\n";
     echo "<tr>\n";
     echo "<th>". $lang['InvPosPos'] ."</th>\n";
     echo "<th>". $lang['InvPosItems'] ."</th>\n";
     echo "<th>". $lang['InvPosIType'] ."</th>\n";
     echo "<th>". $lang['InvPosDesc'] ."</th>\n";
     echo "<th>". $lang['InvPosSingle'] ."</th>\n";
     echo "<th>". $lang['InvPosTax'] ."</th>\n";
     echo "<th>". $lang['InvPosSum'] ."</th>\n";
     echo "<th>". $lang['Currency'] ."</th>\n";
     echo "<th>". $lang['InvDelPos'] ."</th>\n";
     echo "</tr>\n";
     $showed = array();
     $this->obj->read_pos();
     if ( count($this->obj->pos) == 0 ) {
       echo "<tr>\n";
       echo "<td colspan=\"9\" class=\"warn\">".$lang['Err0048']."</td>\n";
       echo "</tr>\n";
     }
     @reset($this->obj->pos) ;
     while ( list ($i,$f) = @each ($this->obj->pos) ) {
       $f->read_ref();
       $showed[$f->ref->id] = 1;
       show_invpos($f,$this->obj);
       unset($f);
     }
     if ( $this->obj->change_ok() ) {
       # The possible positions in the invoice
       echo "<tr>\n";
       echo "<th colspan=\"9\">". $lang['InvPossiblePos'] ."</th>\n";
       echo "</tr>\n";
       echo "<tr>\n";
       echo "<th>&nbsp;</th>\n";
       echo "<th>". $lang['InvPosItems'] ."</th>\n";
       echo "<th>". $lang['InvPosIType'] ."</th>\n";
       echo "<th>". $lang['InvPosDesc'] ."</th>\n";
       echo "<th>". $lang['InvPosSingle'] ."</th>\n";
       echo "<th>". $lang['InvPosTax'] ."</th>\n";
       echo "<th>". $lang['InvPosSum'] ."</th>\n";
       echo "<th>". $lang['Currency'] ."</th>\n";
       echo "<th>". $lang['InvAddPos'] ."</th>\n";
       echo "</tr>\n";

       $p = new invpos($this->dbconn);
       $p->set($this->obj,$this->obj->ref);
       $p->read_ref();
       if ( ! isset($showed[$p->ref->id]) ) {
         show_invpos($p,$this->obj);
       }

       # Time directly booked on the parent object
       $this->obj->ref->readtimetrack();
       @reset($this->obj->ref->ttlist) ;
       while ( list ($i,$f) = @each ($this->obj->ref->ttlist) ) {
         if ( ($f->inv_id == $this->obj->id) && ($this->obj->id != -1) ) {
           continue;
         }
         $p = new invpos($this->dbconn);
         $p->set($this->obj,$f);
         $p->read_ref();
         if ( ! isset($showed[$p->ref->id]) ) {
           show_invpos($p,$this->obj);
         }
         unset($p);
         unset($f);
       }

       # Time booked on tasks
       $this->obj->ref->readtasks();
       foreach ($this->obj->ref->fulltasklist as $i => $f) {
         $p = new invpos($this->dbconn);
         $p->set($this->obj,$f);
         show_invpos($p,$this->obj);
         unset($p);
       }

       # Installation related to out project
       if( $tutos[useinstmanagement] ) {
         loadmodule("installation");
         installation::obj_read($this->obj->ref);
         foreach ($this->obj->ref->instlist as $i => $f) {
           invoice::obj_read($f);
           if (count($f->invlist) > 0 ) {
             continue;
           }
           $p = new invpos($this->dbconn);
           $p->set($this->obj,$f);
           show_invpos($p,$this->obj);
           unset($p);
         }
       }
     }

     # References to modules
     module_addforms($this->user,$this->obj,9);

     if ( $this->obj->mod_ok() != 0 ) {
       echo "<tr>\n";
       if ($this->obj->id > 0 ) {
         submit_reset(0,1,4,1,3,0);
       } else {
         submit_reset(0,-1,4,1,3,0);
       }
       echo "</tr>\n";
     }
     echo $this->DataTableEnd();
     hiddenFormElements();
     echo $this->getHidden();
     echo "</form>\n";
     echo $lang['FldsRequired'] ."\n";
   }
   /**
    * naviagte
    */
   Function navigate() {
     global $lang, $tutos;

     echo "<tr><td>";
     if ( $this->obj->id > 0 ) {
       echo  menulink("invoice/invoice_show.php?id=". $this->obj->id ,$lang['AppSeeEntry'],$lang['AppSeeEntryI']) . "<br>";
     } 
     echo "</td></tr>";
   }
   /**
    * prepare
    */
   Function prepare() {
     global $msg,$lang, $tutos;

     $this->obj = new invoice($this->dbconn);
     $this->name = $lang['Invoice'];

     if ( isset($_GET['id']) ) {
       $this->obj->read($_GET['id']);
       if ($this->obj->id == -1) {
         $msg .= sprintf($lang['Err0040'],$lang[$this->obj->getType()]) . "<br>";
         $this->stop = true;
       }
       $this->name .= ": ". $this->obj->getFullName();
       $this->obj->read_ref();
     } else {
       $this->name = $lang['InvoiceCreate'];
     }

     if ( ($this->obj->id < 0) && !$this->user->feature_ok(useprojects,PERM_NEW) ) {
       $msg .= sprintf($lang['Err0054'],$lang[$this->obj->getType()]);
       $this->stop = true;
     } else if ( ! $this->obj->mod_ok() ) {
       $msg .= sprintf($lang['Err0024'],$lang[$this->obj->getType()]);
       $this->stop = true;
     }

     if ( isset($_GET['state']) ) {
       $this->obj->state = $_GET['state'];
     }
     if ( isset($_GET['name']) ) {
       $this->obj->name = UrlDecode(Stripslashes($_GET['name']));
     }

     if ( isset($_GET['link_id']) ) {
       $this->obj->link_id = $_GET['link_id'];
       if ( $this->obj->id == -1 ) {
         $this->obj->read_ref();
         if ( $this->obj->ref->getType() == "product" ) {
           # Preset the custumer if possible
            $this->obj->ref->readroles();
           if ( isset($this->obj->ref->role[6][0]) ) {
             $this->obj->customer = $this->obj->ref->role[6][0];
           }
         } else if ( $this->obj->ref->getType() == "installation" ) {
           $this->obj->customer = $this->obj->ref->customer;
         }
       }
     }

     # Customer
     preset_from_array_or_input($this->obj,'customer',"c");
     # menu
     $m = invoice::getSelectLink($this->user,$lang['Search']);
     $this->addmenu($m);
     add_module_newlinks($this,$this->obj);

     if ( ($this->obj->id > 0) && $this->obj->del_ok() ) {
       $x = array( url => "invoice/invoice_del.php?id=". $this->obj->id,
                   text => $lang['Delete'],
                   info => sprintf($lang['InvDelInfo'],$this->obj->getFullname()),
                   confirm => true,
                   category => array("invoice","del","obj")
                 );
       $this->addMenu($x);
     }
   }
 }

 $l = new invoice_new($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: invoice_new.php,v 1.28.2.3 2003/07/31 17:56:14 gokohnert Exp $
    $Author: gokohnert $
-->
