<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * insert an invoice to the database
 *
 * @modulegroup invoice
 * @module invoice_ins
 * @package invoice
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'product.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('invoice','ins');
 loadmodule('invoice');

 $gotourl = "invoice/invoice_new.php";
 $msg = "";

 $i = new invoice($dbconn);
 if ( isset($_POST['id']) ) {
   $i->read($_POST['id']);
   if ( $i->id != $_POST['id'] ) {
     $msg .= sprintf($lang['Err0040'],$lang[$i->getType()]);
   } else {
     $gotourl= addUrlParameter($gotourl,"id=". $i->id);
   }
   $i->read_pos();
 } else {
   $i->creator = $current_user;
 }

 if ( isset($_POST['link_id']) ) {
   $i->link_id = $_POST['link_id'];
   $gotourl= addUrlParameter($gotourl,"link_id=". $i->link_id);
 }

 if ( isset($_POST['accountant']) ) {
   $i->setAccountant($_POST['accountant']);
   $gotourl= addUrlParameter($gotourl,"accountant=". $i->accountant);
 }

 if ( isset($_POST['name']) && ($_POST['name'] != "") ) {
   $i->setName(Stripslashes($_POST['name']));
   $gotourl= addUrlParameter($gotourl,"name=". UrlEncode($i->name));
 } else {
   $msg .= sprintf($lang['Err0009'],$lang['InvoiceName']) ."<br>";
 }

 if ( isset($_POST['state']) ) {
   $i->setState($_POST['state']);
   $gotourl= addUrlParameter($gotourl,"state=". $i->state);
 }

 for ( $x = 0 ; $x < 3 ; $x++ ) {
   $d = new DateTime(0);
   $d->setDateTimeF("d". $x);
   $gotourl= addUrlParameter($gotourl,"d".$x."=". $d->getYYYYMMDD() );
   if ( 1 != $d->checkDMY() ) {
     $msg .= sprintf($lang['Err0038'],$lang['InvDateDue'][$i]) ."<br>";
   } else {
     $i->setDateDue($x,$d);
   }

   $d = new DateTime(0);
   $d->setDateTimeF("s". $x);
   $gotourl= addUrlParameter($gotourl,"s".$x."=". $d->getYYYYMMDD() );
   if ( 1 != $d->checkDMY() ) {
     $msg .= sprintf($lang['Err0038'],$lang['InvDateSent'][$i]) ."<br>";
   } else {
     $i->setDateSent($x,$d);
   }
 }

 if ( isset($_POST['cfn']) ) {
   if ( empty($_POST['cfn']) ) {
     $msg .= sprintf($lang['Err0009'],$lang['InvoiceCustomer']) ."<br>";
   } else {
     $customer = check_field($_POST['cfn'],"cfn","cl","acd");
     $i->setCustomer($customer);
   }
 }
 if ( isset($_POST['cid']) ) {
   $m = getObject($dbconn,$_POST['cid']);
   $i->setCustomer($m);
 }
 # Add Positions
 if ( isset($_POST['add']) ) {
   @reset($_POST['add']);
   while (list ($key,$val) = @each ($_POST['add'])) {
     $i->add_Pos($val);
   }
 }

 # Actions in fields

 @reset($_POST);
 while (list ($key,$val) = @each ($_POST)) {
   if ( ereg("^([CIDST])-(.*)",$key,$a) ) {
     if ( !isset($i->pos[$a[2]]) ) {
       $msg .= "missing ". $a[2] ."<br>";
     }
     if ( $a[1] == "T" ) {
       $i->pos[$a[2]]->tax = $val;
     } else 
     if ( $a[1] == "D" ) {
       $i->pos[$a[2]]->description = StripSlashes($val);
     } else 
     if ( $a[1] == "I" ) {
       $i->pos[$a[2]]->items = $val;
     } else
     if ( $a[1] == "S" ) {
       $i->pos[$a[2]]->sum_single = $val;
     }
     if ( $a[1] == "C" ) {
       $i->pos[$a[2]]->currency = $val;
     }
   }
 }

 # Delete Positions
 if ( isset($_POST['del']) ) {
   @reset($_POST['del']);
   while (list ($key,$val) = @each ($_POST['del'])) {
     $i->pos[$val]->DELETE = true;
   }
 }

 # other modules
 $msg .= module_parseforms($current_user,$i,$gotourl);

 if ( $msg == "" ) {
   $dbconn->Begin("WORK");
   $msg .= $i->save();
   $dbconn->Commit("WORK");

   $gotourl = "invoice/invoice_new.php?id=". $i->id;
 }
 $gotourl = addSessionKey($gotourl);
 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));

 Header("Status: 302 Moved Temporarily");
 Header("Location: ". dirname(getBaseUrl()) ."/". $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: invoice_ins.php,v 1.10.2.2 2003/06/18 14:34:32 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
