<?php
/**
 * Copyright 1999 - 2003 by Gero Kohnert
 *
 * this script parses all the inputs and stores the object into the database.
 * on completition it jumps to the detail screen of the stored object
 *
 * @modulegroup file
 * @module file_ins
 * @package file
 */
 $tutos['base'] = "../..";
 ini_set("include_path","..");
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('file','ins');
 loadmodule('file');

 $f = new tutos_file($dbconn);

 /* Check Input */
 $msg = "";
 $log = "";

 if ( empty($_POST['gotourl']) ) {
   $gotourl = "file/file_new.php";
 } else {
   $gotourl = $_POST['gotourl'];
 }

 if ( isset($_POST['id']) ) {
   $f->read($_POST['id']);
   $gotourl = addUrlParameter($gotourl,"id=". $f->id );
 }
 if ( $f->id == -1 ) {
   # Versioning System could only be set at first save

   if ( isset($_POST['vsys']) ) {
     $f->vsys = $_POST['vsys'];
   }
 }
 if ( isset($_POST['save']) ) {
   $f->savemode = $_POST['save'];
 }

 if ( !isset($_POST['link_id']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['FileReference']) ."<br>";
 } else {
   $f->link_id = $_POST['link_id'];
   $gotourl = addUrlParameter($gotourl,"link_id=". UrlEncode($f->link_id));
 }

 $file = 'none';
 # Hack for Konquerer
 if ( isset($_POST['file']) ) {
   $file = $_POST['file'];
   if ( $file != "none" ) {
     $farr = $HTTP_POST_FILES["file"];
     if ( $farr['name'] == "" ) {
       $file = "none";
     }
   }
 } else if ( isset($HTTP_POST_FILES['file']) ) {
   $file = $HTTP_POST_FILES['file']['name'];
 }
 if ( $file == "" ) {
   $file = 'none';
 }
 # New files need a path !
 if ( ($file == "none") && ($f->id == -1)  ) {
   $msg .= sprintf($lang['Err0009'],$lang['FileName']) ."<br>";
 }

 if ( ( !isset($_POST['name']) || $_POST['name'] == "") && ($file == "none") ) {
   $msg .= sprintf($lang['Err0009'],$lang['FileName']) ."<br>";
   $name = "";
 } else {
   $name = trim($_POST['name']);
 }

 if ( $name != "" ) {
   $gotourl = addUrlParameter($gotourl,"name=". UrlEncode(StripSlashes($name)));
 }

 if ( isset($_POST['version']) && ($_POST['version'] != "") ) {
   $version = $_POST['version'];
 } else {
   $version = "";
 }
 $gotourl = addUrlParameter($gotourl,"version=". UrlEncode(StripSlashes($version)));


 if ( isset($_POST['locked']) && ($f->locked != $_POST['locked']) ) {
   if ( $_POST['locked'] > 0 ) {
     $f->locker = new tutos_address($dbconn);
     $f->locker->read($_POST['locked']);
     $log = $log . "Document locked by ". $f->locker->getFullName() ."\n";
   } else {
     $log = $log . "Document unlocked by ". $current_user->getFullName() ."\n";
   }
   $f->locked = $_POST['locked'];
 }

 if ( isset($_POST['afn']) ) {
   # Check the author full name
   $author = check_field($_POST['afn'],"afn","al","at");
 }

 if ( $file != "none" ) {
   $farr = $HTTP_POST_FILES['file'];
   if ( $f->id > 0 ) {
     $log .=  "Changed Document \n";
     if ( $f->filename != $farr['name'] ) {
       $log .= "  Name: from ". $f->filename ." to ". $farr['name'] ."\n";
     }
     if ( $f->filesize != $farr['size'] ) {
       $log .= "  Size: from ". $f->filesize ." to ". $farr['size'] ."\n";
     }
     if ( $f->filetype != $farr['type'] ) {
       $log .= "  Type: from ". $f->filetype ." to ". $farr['type'] ."\n";
     }
   }
   if ( $name == "") {
     $name = $farr['name'];
   }
   if ( isset($farr['tmp_name']) && file_exists($farr['tmp_name']) ) {
     $f->tmploc = $farr['tmp_name'];
     $f->filesize = $farr['size'];
     $f->setFilename($farr['name']);
     $f->filetype = $farr['type'];
   } else {
     if ( isset($farr['tmp_name']) ) {
       $msg .= "Temporary file '". $farr['tmp_name'] ."' missing. Maybe too big";
     } else {
       $msg .= "Temporary file missing. Maybe too big";
     }
   }
 }

 # other modules
 $msg .= module_parseforms($current_user,$f,$gotourl);

 if ( $msg == "" ) {
   $f->oldversion = $f->version;
   $f->setVersion($version);

   if ( isset($_POST['aid']) ) {
     $author = getObject($f->dbconn,$_POST['aid']);
   }
   if ( isset($author) ) {
     if ( $f->author->id != $author->id ) {
       $log = $log . "Changed Author from ". $f->author->getFullName() ." to ". $author->getFullName() ."\n";
     }
     $f->setAuthor($author);
   }

   if ( ($f->name != $name) && ($f->name != "") ) {
     $log = $log . "Changed Documentname from ". $f->name ." to " . $name ."\n";
   }
   $f->setName($name);

   if ( $log != "" ) {
     $log = "----------- <b>". Date("j M Y  H:i:s") ." -- ". $current_user->getFullName() ." </b>---\n" . $log;
     $f->logtxt = $log. $f->logtxt;
   }
   # Save the new part of logmessage for RCS
   $f->newlog = $log;

   $dbconn->Begin("WORK");
   $msg .= $f->save();
   $dbconn->Commit("WORK");

   if ( $f->id != -1 ) {
     $gotourl = $f->getURL();
   }
 }

 if ( $msg != "" ) {
   $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
   $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));
 }
 $gotourl = addSessionKey($gotourl);


 Header("Status: 302 Moved Temporarily");
 Header("Location: ". dirname(getBaseUrl()) ."/". $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: file_ins.php,v 1.5.2.2 2003/06/18 14:34:32 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
