<?php
/**
 * Copyright 2001 - 2003 by Gero Kohnert
 *
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules("database","ins");

 $gotourl = "database_new.php";
 $msg = "";

 $obj = new database($dbconn);
 if ( isset($_POST['id']) ) {
   $obj->read($_POST['id']);
   $gotourl= addUrlParameter($gotourl,"id=". $obj->id);
 }

 if ( empty($_POST['name']) || !isset($_POST['name']) || ($_POST['name'] == $lang['PlsChangeName']) ) {
   $msg .= sprintf($lang['Err0009'],$lang['AdminDBName']) ."<br>";
 } else {
   $name = trim(StripSlashes($_POST['name']));
   $gotourl = addUrlParameter($gotourl,"name=". UrlEncode($name));
 }

 $type = trim(StripSlashes($_POST['type']));
 $gotourl = addUrlParameter($gotourl,"type=". UrlEncode($type));

 $alias = trim(StripSlashes($_POST['alias']));
 $gotourl = addUrlParameter($gotourl,"alias=". UrlEncode($alias));

 $host = trim(StripSlashes($_POST['host']));
 $gotourl = addUrlParameter($gotourl,"host=". UrlEncode($host));

 $port = trim(StripSlashes($_POST['port']));
 $gotourl = addUrlParameter($gotourl,"port=". UrlEncode($port));

 $user = trim(StripSlashes($_POST['user']));
 $gotourl = addUrlParameter($gotourl,"user=". UrlEncode($user));

 $pass = trim(StripSlashes($_POST['pass']));
 $gotourl = addUrlParameter($gotourl,"pass=". UrlEncode($pass));

 $home = trim(StripSlashes($_POST['home']));
 $gotourl = addUrlParameter($gotourl,"home=". UrlEncode($home));

 $rep = trim(StripSlashes($_POST['rep']));
 $gotourl = addUrlParameter($gotourl,"rep=". UrlEncode($rep));

 $logo = trim(StripSlashes($_POST['logo']));
 $gotourl = addUrlParameter($gotourl,"logo=". UrlEncode($logo));

 $logolink = trim(StripSlashes($_POST['logolink']));
 $gotourl = addUrlParameter($gotourl,"logolink=". UrlEncode($logolink));

 $vatlist = trim(StripSlashes($_POST['vatlist']));
 $gotourl = addUrlParameter($gotourl,"vatlist=". UrlEncode($vatlist));

 $bugautoname = trim(StripSlashes($_POST['bugautoname']));
 $gotourl = addUrlParameter($gotourl,"bugautoname=". UrlEncode($bugautoname));

 $invautoname = trim(StripSlashes($_POST['invautoname']));
 $gotourl = addUrlParameter($gotourl,"invautoname=". UrlEncode($invautoname));

 # other modules
 $msg .= module_parseforms($current_user,$obj,$gotourl);

 if ( $msg == "" ) {
   $obj->SetName($name);
   $obj->SetAlias($alias);
   $obj->SetHost($host);
   $obj->SetPort($port);
   $obj->SetUser($user);
   $obj->SetPass($pass);
   $obj->SetHome($home);
   $obj->setRepository($rep);
   $obj->setType($type);
   $obj->setLogo($logo);
   $obj->setLogoLink($logolink);
   $obj->setBugAutoname($bugautoname);
   $obj->setInvAutoname($invautoname);
   $obj->setVATlist($vatlist);

   $dbconn->Begin("WORK");
   $msg = $obj->save();
   $dbconn->Commit("WORK");

   $gotourl = $obj->getURL();
 }

 $_SESSION['MSGID'.strlen($msg)] = UrlEncode($msg);
 $gotourl = addUrlParameter($gotourl,"msgid=MSGID". strlen($msg));

 $gotourl = addSessionKey($gotourl);

 Header("Status: 302 Moved Temporarily");
 Header("Location:". getBaseUrl() . $gotourl);
 $dbconn->Close();
 /*
  *  CVS Info:  $Id: database_ins.php,v 1.14.2.2 2003/06/18 14:34:32 gokohnert Exp $
  *  $Author: gokohnert $
  */
?>
