<?php
/**
 * Copyright 2001 - 2002 by Gero Kohnert
 *
 * A calendar for one week
 *
 * @modulegroup appointment
 * @module calendar_week
 */
 include_once 'webelements.p3';
 include_once 'permission.p3';
 include_once 'task.pinc';
 include_once 'appointment.pinc';
 include_once 'product.pinc';
 include_once 'bug.pinc';
 include_once 'timetrack.pinc';

 /* Check if user is allowed to use it */
 check_user();
 loadmodules('appointment','show');
 loadlayout();

 /**
  * display a calendar dfor a week
  */
 class calendar_week extends layout {
   /**
    * A one week calendar sheet
    */
   Function info() {
     global $lang,$tutos;

     $adr = $this->user;
     $ts = mktime(12,0,0,substr($this->t,4,2),substr($this->t,6,2),substr($this->t,0,4));

     /* Back to last Monday or Sunday before ts */
     while ( Date("w",$ts) != $this->user->weekstart ) {
       $ts -= 86400;
     }

     $w0 =  (( 1 + Date("w",mktime(12,0,0,1,1, Date("Y",$ts) ) )) % 7) > 3;
     $wn = sprintf("%02d", Round( (Date("z",$ts)+7 ) / 7) );
     $yy = Date("y",$ts);

     $last_week = Date("Ymd",$ts -  7 * 86400);
     $next_week = Date("Ymd",$ts +  7 * 86400);

     echo "<form action=\"calendar_week.php\" method=\"GET\">\n";

     echo "<table class=\"single\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"100%\">\n";
     echo " <tr>\n";
     echo "  <th align=\"left\" nowrap colspan=\"2\">&nbsp;". $lang['forphrase'] ."\n";
     cal_options($this->team,$this->teamname);
     echo "  </th>\n";
     echo " </tr>\n";
     echo " <tr>\n";
     echo "  <th colspan=\"2\" width=\"100%\">".menulink("calendar_week.php?t=".$last_week,$this->theme->getImage(left,'list'),$lang['lastweek']) ."&nbsp;". $lang['week'] ."&nbsp;" . $wn . "/". $yy ."&nbsp;". menulink("calendar_week.php?t=".$next_week,$this->theme->getImage(right,'list') ,$lang['nextweek']) ."</th>\n";
     echo " </tr>\n";

     $from =  new DateTime();
     $from->setDateTimeTS($ts - 12 * 3600);
     $to = $from;
     $to->addDays(7);

     $this->user->callist = array();
     appointment::readCal($this->user,$from,$to);
     task::readCal($this->user,$from,$to);

     foreach($tutos[activemodules] as $i => $f) {
       $x = &new $tutos[modules][$f][name]($this->dbconn);
       $x->readCal($this->user,$from,$to);
     }

     $day = 0;
     $col = 1;
     $dd = new DateTime();
     while ( $day < 7 ) {
       $dd->setDateTimeTS($ts);
       $d = $dd->getDate();
       $tref = Date("Ymd",$ts);
       $dinfo = GetDaysInfo($ts);
       /* Select appointments for this day */
       $next = NextDay($ts);

       if ( $col == 1 ) {
         echo " <tr>\n";
       }
       echo "  <td class=\"". $dinfo[color] ."\" width=\"50%\">\n";

       # TABLE STARTS
       echo "<table class=\"single\" border=\"0\" cellpadding=\"3\" cellspacing=\"0\" width=\"100%\">\n";
       echo " <tr>\n";
       echo "  <th>". menulink("calendar_day.php?t=". $tref,$lang['Day'. Date("w",$ts)],strftime($lang['DateFormatTitle'],$ts)) ."</th>\n";
       echo " </tr>\n";
       echo " <tr>\n";
       echo "  <td class=\"". $dinfo[color] ."\" width=\"50%\">\n";
       if ( isset($dinfo[Desc]) ) {
         echo " " . makelink("app_new.php?t=". $tref,$d,$lang['NewAppointInfo'],$dinfo[popinfo]) ."\n";
         echo "<br><span class=\"dinfo\">". $dinfo[Desc] ."</span>\n";
       } else {
         echo " " . makelink("app_new.php?t=". $tref,$d,$lang['NewAppointInfo']) ."\n";
       }

       $hastable = 0;
       $x = count( $this->user->callist );
       for ( $idx = 0 ; $idx < $x ; $idx++) {
         /* the correct day */
         if ( ! $this->user->callist[$idx]->inside($dd) ) {
           continue;
         }
         if (!cal_check_against_list($this->user->callist[$idx],$this->uids)) {
           continue;
         }
         // Do not show finished tasks
         if ( ($this->user->callist[$idx]->gettype() == "task") && ($this->user->callist[$idx]->state == 2) ) {
           continue;
         }
         if ( $hastable == 0 ) {
           echo " <table cellspacing=\"0\" cellpadding=\"0\" border=\"0\" width=\"100%\">\n";
           $hastable = 1;
         } else {
           echo "  <tr><td class=\"". $dinfo[color] ."\" colspan=\"3\"><img src=\"". $tutos['base'] ."/html/black.png\" width=\"100%\" height=\"1\" alt=\"--------\"></td></tr>\n";
         }
         // Show appointments or task
         $this->user->callist[$idx]->formatted();
       }

       if ( $hastable == 1 ) {
         echo " </table>\n";
       }

       # TABLE ENDS
       echo "</table>\n";

       echo "  </td>\n";
       if ( $col == 2 ) {
         echo " </tr>\n";
         $col = 0;
       }

       $day++;
       $col++;
       $ts = $next;
     }

     echo "</table>\n";
     hiddenFormElements();
     $this->addHidden("t", $this->t);
     echo $this->getHidden();
     echo "</form>\n";
   }
   /**
    * naviagte
    */
   Function navigate() {
   }
   /**
    * prepare
    */
   Function prepare() {
     global $tutos, $lang;

     $this->name = $lang['Calendar'];

     $this->team = $this->user->get_prefteam();
     $this->teamname = "";
     $this->uids = cal_parse_options($this->user,$this->teamname);
     $this->t = $_GET['t'];
     # menu
     $m = appointment::getSelectLink($this->user);
	 $m[category][] = "obj";
     $this->addmenu($m);
     $m = appointment::getAddLink($this->user,$this->user);
     $this->addMenu($m);
   }
 }

# info($_GET['t'],$current_user->get_prefteam(),$teamname,$uids);

 $l = new calendar_week($current_user);
 $l->display();
 $dbconn->Close();
?>
<!--
    CVS Info:  $Id: calendar_week.php,v 1.33.2.2 2003/10/14 16:16:31 gokohnert Exp $
    $Author: gokohnert $
-->
