<?php

$block_name = _("Mini Search");

/**
 * Turba_Minisearch_Block:: Implementation of the Horde_Block API to
 * allows searching of addressbooks from the portal.
 *
 * $Horde: turba/lib/Block/minisearch.php,v 1.17 2004/12/11 15:43:13 jan Exp $
 *
 * @package Horde_Block
 */
class Horde_Block_turba_minisearch extends Horde_Block {

    var $_app = 'turba';

    /**
     * The title to go in this block.
     *
     * @return string   The title text.
     */
    function _title()
    {
        global $registry;

        $html  = Horde::link(Horde::url($registry->getInitialPage(), true), $registry->get('name'), 'header') . $registry->get('name') . '</a> :: ';
        $html .= Horde::link(Horde::applicationUrl('add.php', true), _("New Contact"), 'smallheader') . Horde::img('new.png', _("New Contact"), 'align="middle"', Horde::url($registry->getImageDir(), true, -1)) . ' ' . _("New Contact") . '</a>';

        return $html;
    }

    /**
     * The content to go in this block.
     *
     * @return string   The content
     */
    function _content()
    {
        global $browser, $registry, $prefs;
        require_once dirname(__FILE__) . '/../base.php';

        if ($browser->hasFeature('iframes')) {
            return Util::bufferOutput('include', TURBA_TEMPLATES . '/block/minisearch.inc');
        } else {
            return '<i>' . _("A browser that supports iFrames is required") . '</i>';
        }
    }

}
