<?php
/**
 * $Horde: turba/display.php,v 1.64.2.1 2005/01/03 12:25:47 jan Exp $
 *
 * Copyright 2000-2005 Charles J. Hagenbuch <chuck@horde.org>
 *
 * See the enclosed file COPYING for license information (ASL).  If you
 * did not receive this file, see http://www.horde.org/licenses/asl.php.
 */

@define('TURBA_BASE', dirname(__FILE__));
require_once TURBA_BASE . '/lib/base.php';
require_once TURBA_BASE . '/lib/Renderer.php';
require_once TURBA_BASE . '/lib/ObjectView.php';
require_once 'Horde/Form.php';
require_once 'Horde/Variables.php';

$renderer = &new Turba_Renderer();
$vars = &Variables::getDefaultVariables();

$source = $vars->get('source');
if (!isset($cfgSources[$source])) {
    $notification->push(_("The contact you requested does not exist."));
    header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
    exit;
}

$driver = &Turba_Driver::singleton($source, $cfgSources[$source]);

/* Get the form object. */
$form = &Horde_Form::singleton('', $vars);
$form->addHidden('', 'url', 'text', false);
$form->addHidden('', 'source', 'text', true);
$form->addHidden('', 'key', 'text', false);

/* Set the contact from the key requested. */
$key = $vars->get('key');
$object = $driver->getObject($key);
if (is_a($object, 'PEAR_Error')) {
    $notification->push($object->getMessage(), 'horde.error');
    header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
    exit;
}

/* Check permissions on this contact. */
$readonly = false;
if (!Turba::hasPermission($object, 'object', PERMS_READ)) {
    $notification->push(_("You do not have permission to view this contact."), 'horde.error');
    header('Location: ' . Horde::applicationUrl($prefs->getValue('initial_page'), true));
    exit;
}

$renderer->setObject($object);
$view = &new Turba_ObjectView($object);

$values = array();
/* Get the values through the AbstractObject class. */
foreach ($object->driver->getCriteria() as $info_key => $info_val) {
    $values[$info_key] = $object->getValue($info_key);
}

/* Get the contact's history. */
if ($object->getValue('__uid')) {
    $history = &Horde_History::singleton();
    $log = $history->getHistory('turba:' . ($object->getValue('__owner') ? $object->getValue('__owner') : Auth::getAuth()) . ':' . $object->getValue('__uid'));
    foreach ($log->getData() as $entry) {
        switch ($entry['action']) {
        case 'add':
            $view->set('created', true);
            $values['__created'] = strftime($prefs->getValue('date_format'), $entry['ts']) . ' ' . date($prefs->getValue('twentyFour') ? 'G:i' : 'g:i a', $entry['ts']);
            break;

        case 'modify':
            $view->set('modified', true);
            $values['__modified'] = strftime($prefs->getValue('date_format'), $entry['ts']) . ' ' . date($prefs->getValue('twentyFour') ? 'G:i' : 'g:i a', $entry['ts']);
            break;
        }
    }
}

$view->setupForm($form);

$vars = &new Variables(array('object' => $values));
$title = $vars->get('object[name]');
if (!empty($title) || $title == '0') {
    $form->setTitle($title);
}

require TURBA_TEMPLATES . '/common-header.inc';
require TURBA_TEMPLATES . '/menu.inc';
$form->renderInactive($renderer, $vars);
require $registry->get('templates', 'horde') . '/common-footer.inc';
