/***************************************************************************
 *   Project TUPI: Magia 2D                                                *
 *   Project Contact: info@maefloresta.com                                 *
 *   Project Website: http://www.maefloresta.com                           *
 *   Project Leader: Gustav Gonzalez <info@maefloresta.com>                *
 *                                                                         *
 *   Developers:                                                           *
 *   2010:                                                                 *
 *    Gustavo Gonzalez                                                     *
 *                                                                         *
 *   KTooN's versions:                                                     * 
 *                                                                         *
 *   2006:                                                                 *
 *    David Cuadrado                                                       *
 *    Jorge Cuadrado                                                       *
 *   2003:                                                                 *
 *    Fernado Roldan                                                       *
 *    Simena Dinas                                                         *
 *                                                                         *
 *   Copyright (C) 2010 Gustav Gonzalez - http://www.maefloresta.com       *
 *   License:                                                              *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>. *
 ***************************************************************************/

#ifndef KTCANVAS_H
#define KTCANVAS_H

#include "ktgraphicsscene.h"
#include "ktcanvasview.h"

#include <QFrame>
// #include <QDialog>
#include <QPointF>
#include <QSize>
#include <QCloseEvent>

class KTGraphicsScene;

// class KTCanvas : public QDialog

class KTCanvas : public QFrame
{
    Q_OBJECT

    public:
        KTCanvas(QWidget *parent=0, Qt::WindowFlags f=0, KTGraphicsScene *scene=0, 
                 const QPointF centerPoint = QPoint(0, 0) , const QSize &size = QSize(0, 0), 
                 const QSize &projectSize = QSize(0, 0), double scaleFactor = 1, 
                 int angle=0, const QColor &bg = QColor(Qt::white));
        ~KTCanvas();
        void updateCursor(const QCursor &cursor);

   protected:
        void closeEvent(QCloseEvent *event);

    private:
        KTCanvasView *graphicsView;
};

#endif
