//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#include "SpreadView.h"

#include <iostream>

#include <tulip/Graph.h>

using namespace std;

namespace tlp {

  SpreadView::SpreadView() :AbstractView() {
  }

  QWidget *SpreadView::construct(QWidget *parent) {
  	QWidget *widget=AbstractView::construct(parent);
    mainWidget=new SpreadWidget(widget);
    setCentralWidget(mainWidget);
    return widget;
  }

  void SpreadView::setData(Graph *graph,DataSet dataSet) {
    mainWidget->setData(graph,dataSet);
  }

  void SpreadView::getData(Graph **graph,DataSet *dataSet) {
    dataSet->set<DataSet>("data",DataSet());
    *graph=mainWidget->getGraph();
  }

  Graph* SpreadView::getGraph() {
    return mainWidget->getGraph();
  }

  void SpreadView::setGraph(Graph *graph) {
    mainWidget->setData(graph,DataSet());
  }

  void SpreadView::draw() {
    mainWidget->redrawView();
  }

  void SpreadView::refresh() {
    draw();
  }

  void SpreadView::init() {
    draw();
  }

  VIEWPLUGIN(SpreadView, "Table view", "Tulip Team", "16/04/2008", "Spreadsheet view", "1.0");

}
