//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef _TREELEAFLAYOUT_H
#define _TREELEAFLAYOUT_H

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

#include <tulip/TulipPlugin.h>

/** \addtogroup layout */
/*@{*/
/// TreeMap.h - An implementation of the tree map layout.
/** This plugin is an implementation of the tree map layout
 *  algorithm first published as:
 *
 *  Shneiderman, B. (March 1991) \n
 *  Tree visualization with treemaps: a 2-d space-filling approach \n
 *  ACM Transactions on Graphics, vol. 11, 1 (Jan. 1992) 92-99. \n
 *  HCIL-91-03, CS-TR-2645, CAR-TR-548  
 *
 *  <b>HISTORY</b>
 *
 *  - 01/04/99 Verson 0.0.1: Initial release
 *
 *  \note This algorithm only works on trees.
 *  This version use the "viewMetric" property to determine
 *  The size of elements. \n
 *  Let n be the number of nodes, the algorithm complexity is in O(n).
 *
 *
 *  \author David Auber University Bordeaux I France: Email:auber@tulip-software.org
 *
 *  <b>LICENCE</b>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by  
 *  the Free Software Foundation; either version 2 of the License, or     
 *  (at your option) any later version.
 *
*/
class TreeMap:public tlp::LayoutAlgorithm { 
public:
  TreeMap(const tlp::PropertyContext &);
  ~TreeMap();
  bool run();
  bool check(std::string &);

private:
  void dfsPlacement(tlp::node n, int depth, double x, double y, double width, double height,
		    bool direction, stdext::hash_map<tlp::node,double> &value);
  double initVal(tlp::node n, stdext::hash_map<tlp::node,double> &value);
  tlp::SizeProperty *size;
  tlp::DoubleProperty *metric;
  tlp::ColorProperty *color;
};
/*@}*/
#endif










