//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef HASH_STRING_H
#define HASH_STRING_H

#ifndef DOXYGEN_NOTFOR_DEVEL
#include <string>

namespace stdext {
	/**
   * \addtogroup basic
   */ 
  /*@{*/
  /**
   * \brief provides string hash method 
   *
   *
   * \author : David Auber auber@tulip-software.org
   * \version 0.0.1 24/01/2003 
   */
  template<> struct hash<const std::string>{
    size_t operator()(const std::string &s) const {return hash<const char *>()(s.c_str()); }
  };
  template<> struct hash<std::string>{
    size_t operator()(const std::string &s) const {return hash<const char *>()(s.c_str()); }
  };
   /*@}*/
}

#endif //DOXYGEN_NOTFOR_DEVEL
#endif //HASH_STRING_H
