//-*-c++-*-
/**
 Authors: David Auber, Patrick Mary, Morgan Mathiaut
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/03/2009 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef _Tulip_NODELINKDIAGRAMCOMPONENT_H
#define _Tulip_NODELINKDIAGRAMCOMPONENT_H

#include "GlMainView.h"


namespace tlp {

  /** \brief Main view of old Tulip
   *
   * This class provide a graph view based to nodes and links
   * Rendering is do with OpenGl
   */
  class TLP_QT_SCOPE NodeLinkDiagramComponent : public GlMainView{

    Q_OBJECT;

  public:

    NodeLinkDiagramComponent();
    virtual ~NodeLinkDiagramComponent();

    QWidget *construct(QWidget *parent);

    void setData(Graph *graph,DataSet dataSet);
    void getData(Graph **graph,DataSet *dataSet);

    void installInteractor(QAction *);

    void specificEventFilter(QObject *object,QEvent *event);
    void buildContextMenu(QObject *object,QMouseEvent *event,QMenu *contextMenu);
    void computeContextMenuAction(QAction *action);

  protected :

    QMenu *viewMenu;
    QMenu *dialogMenu;
    QMenu *optionsMenu;
    QMenu *exportImageMenu;
    QAction *actionTooltips;
    QAction *actionsGridOptions;
    QAction *actionZOrderingOptions;
    QAction *actionAntialiasingOptions;
    QAction *renderingParametersDialogAction;
    QAction *augmentedDisplayDialogAction;
    QAction* addRemoveAction;
    QAction* selectAction;
    QAction* deleteAction;
    QAction* goAction;
    QAction* ungroupAction;
    QAction* propAction;
    bool isNode;
    int itemId;

    GridOptionsWidget *gridOptionsWidget;
    RenderingParametersDialog *renderingParametersDialog;
    LayerManagerWidget *layerWidget;

    std::map<std::string,DataSet> algorithmInfoDataSet;

    void constructInteractorsActionList();
    void constructInteractorsMap();
    void addLayer(tlp::GlScene*, const std::string&, tlp::GlLayer*);
    void modifyLayer(tlp::GlScene*, const std::string&, tlp::GlLayer*);
    void checkAlgorithmResult();

  protected slots:
    void showDialog(QAction*);
    void gridOptions();

  public slots:
    void centerView();
    void draw();
    void refresh();
    void init();
    void setGraph(Graph *graph);

    void elementSelectedSlot(unsigned int id,bool isNode) {
      emit elementSelected(id,isNode);
    }

  };

}

#endif






