//-*-c++-*-
/**
 Authors: David Auber, Romain Bourqui, Patrick Mary
 from the LaBRI Visualization Team
 Email : auber@tulip-software.org
 Last modification : 13/07/2007 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef _GL_INTERACTOR_H
#define _GL_INTERACTOR_H

#if (QT_REL == 3)
#include <qobject.h>
#else
#include <Qt/qobject.h>
#endif

class GlGraphWidget;

namespace tlp {

  /// The class uses to manage event filters on a GlGraphWidget
  class GWInteractor : public QObject {
  public:
    typedef unsigned int ID;
  protected:
    ID id;
  public:
    GWInteractor() {}
    virtual ~GWInteractor() {}
    /// an interactor may do some drawing feedback on the GlGraphWidget it interacts with
    virtual bool draw(GlGraphWidget *){ return false; }
    virtual GWInteractor *clone() = 0;
    ID getID() { return id; }
    void setID(ID i) { id = i; }
    static const ID invalidID = 0;
};

}

#endif






