//*********************************************************************************
//** GlADRenderOptions.cpp : Source for a rendering options class
//** 
//** author : Delorme Maxime
//** date   : 07/11/05
//*********************************************************************************

#include "tulip/GlADRenderOptions.h"

namespace tlp
{
  GlADRenderOptions::GlADRenderOptions()
  {
    renderStatesValue = 2 + 8 + 32; // We enable GlAD_Solid, GlAD_ZEnable and GlAD_Culling
  }

  GlADRenderOptions::GlADRenderOptions(int baseValue)
  {
    renderStatesValue = baseValue;
  }

  GlADRenderOptions::~GlADRenderOptions()
  {
  }

  void GlADRenderOptions::setRenderOptions(const GlADRenderOptions &renderOptions)
  {
    renderStatesValue = renderOptions.renderStatesValue;
  }

  void GlADRenderOptions::setRenderState(GlADRenderState renderState, bool value)
  {
    int bit  =  1 << renderState;
    int mask = (1 << (N_RENDERSTATES + 1)) - 1;

    if (value)
      renderStatesValue = renderStatesValue | bit;
    else
      renderStatesValue = renderStatesValue & (mask - bit);
  }

  bool GlADRenderOptions::getRenderState(GlADRenderState renderState) const
  {
    int bit = 1 << renderState;

    if ((renderStatesValue & bit) > 0)
      return true;

    return false;
  }

  void GlADRenderOptions::setup()
  {
    if (getRenderState(GlAD_AlphaBlending))
      {
	glEnable(GL_BLEND);
       
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
      }
    else
      glDisable(GL_BLEND);

    if (getRenderState(GlAD_ZEnable))
      glEnable(GL_DEPTH_TEST);
    else
      glDisable(GL_DEPTH_TEST);

    if (getRenderState(GlAD_Lighting))
      glEnable(GL_LIGHTING);
    else
      glDisable(GL_LIGHTING);

    if (getRenderState(GlAD_Culling))
      glEnable(GL_CULL_FACE);
    else
      glDisable(GL_CULL_FACE);
  }
}
