//-*-c++-*-

#include "tulip/SelectionProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/Selection.h"
#include "tulip/PropertyProxy.h"
#include "tulip/GraphIterator.h"

using namespace std;

//=================================================================================
SelectionProxy::SelectionProxy (SuperGraph *graph):PropertyProxy<BooleanType,BooleanType, Selection>(graph) {
  //  propertyProxy=this;
}
//=================================================================================
SelectionProxy::~SelectionProxy() {
  notifyDestroy();
}  
//=================================================================================
///Poign� permettnet le reset des variables du MetricProxy par le PropertyProxy
void SelectionProxy::reset_handler() {
}
//=================================================================================
Iterator<node>* SelectionProxy::getNodesEqualTo(const bool val, SuperGraph *graph) {
  if (graph == 0) graph = superGraph;
  Iterator<unsigned int> *it = 0;
  if (graph == superGraph) {
    try {
      it = nodeProperties.findAll(val);
    } catch (ImpossibleOperation &e) {
      it=0;
    }
  }
  if (it==0)
    return (new SGraphNodeIterator(graph, nodeProperties));
  else
    return (new UINTIterator<node>(it));
}
//=================================================================================
Iterator<edge>* SelectionProxy::getEdgesEqualTo(const bool val, SuperGraph *graph) {
  if (graph == 0) graph = superGraph;
  Iterator<unsigned int> *it=0;
  if (graph == superGraph) {
    try {
      it = edgeProperties.findAll(val);
    } catch (ImpossibleOperation &e) {
      it=0;
    }
  }
  if (it==0)
    return (new SGraphEdgeIterator(graph, edgeProperties));
  else
    return (new UINTIterator<edge>(it));
}
//=================================================================================
//Fonctionnalit� suppl�mentaire ajout� au seletion Proxy
void SelectionProxy::reverse() {
  Observable::holdObservers();
  Iterator<node> *itN=superGraph->getNodes();
  while (itN->hasNext()) {
    node itn=itN->next();
    if (getNodeValue(itn)==true)
      setNodeValue(itn,false);
    else
      setNodeValue(itn,true);
  } delete itN;
  Iterator<edge> *itE=superGraph->getEdges();
  while (itE->hasNext()) {
    edge ite=itE->next();
    if (getEdgeValue(ite)==true)
      setEdgeValue(ite,false);
    else
      setEdgeValue(ite,true);
  } delete itE;
  notifyObservers();
  Observable::unholdObservers();
}
//=================================================================================
void SelectionProxy::reverseEdgeDirection() {
  Iterator<edge> *itE=superGraph->getEdges();
  while (itE->hasNext()) {
    edge ite=itE->next();
    if (getEdgeValue(ite))
      superGraph->reverse(ite);
  } delete itE;
}
//=================================================================================
PProxy* SelectionProxy::clonePrototype(SuperGraph * g, std::string n)
{
	if( !g )
		return 0;
	SelectionProxy * p = g->getLocalProperty<SelectionProxy>( n );
	p->setAllNodeValue( getNodeDefaultValue() );
	p->setAllEdgeValue( getEdgeDefaultValue() );
	return p;
}
//=============================================================
void SelectionProxy::copy( const node n0, const node n1, PProxy * p )
{
	if( !p )
		return;
	SelectionProxy * tp = dynamic_cast<SelectionProxy*>(p);
	assert( tp );
	setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void SelectionProxy::copy( const edge e0, const edge e1, PProxy * p )
{
	if( !p )
		return;
	SelectionProxy * tp = dynamic_cast<SelectionProxy*>(p);
	assert( tp );
	setEdgeValue( e0, tp->getEdgeValue(e1) );
}



