//-*-c++-*-
/*
 Author: Delorme Maxime
 Email : Maxime.Delorme@gmail.com

 Last modification : 05/08/2005 (fr) 

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#include "tulip/GlHudLine.h"

using namespace std;

namespace tlp
{
  GlHudLine::GlHudLine()
  {
  }

  GlHudLine::GlHudLine(const Coord &startPos, const Coord &endPos, const Color &startCol, const Color &endCol, unsigned int thickness)
  {
    this->startPos  = new Coord(startPos);
    this->endPos    = new Coord(endPos);
    this->startCol  = new Color(startCol);
    this->endCol    = new Color(endCol);
    this->thickness = thickness;
  }

  GlHudLine::~GlHudLine()
  {
    delete startPos;
    delete endPos;
    delete startCol;
    delete endCol;
  }

  void GlHudLine::draw(GlGraph* graph)
  {
    setup();

    GLfloat *scol = startCol->getGL();
    GLfloat *ecol = endCol->getGL();

    Coord start, end;
    
    start = transformCoordinates(*startPos);
    end   = transformCoordinates(*endPos);

    // cout << "start; end = " << start << "; " << end << endl;

    int viewport[4];

    glBegin(GL_LINES);   

    glLineWidth(thickness);

    glColor4fv(scol);
    glVertex3d(start.getX(), start.getY(), start.getZ());

    glColor4fv(ecol);
    glVertex3d(end.getX(), end.getY(), end.getZ());

    glEnd();

    unsetup();
  }

  
  Coord GlHudLine::getStartPosition() const
  {
    return *startPos;
  }

  Coord GlHudLine::getEndPosition() const
  {
    return *endPos;
  }

  Color GlHudLine::getStartColor() const
  {
    return *startCol;
  }

  Color GlHudLine::getEndColor() const
  {
    return *endCol;
  }

  unsigned int GlHudLine::getThickness() const
  {
    return thickness;
  }

  void GlHudLine::setStartPosition(const Coord &startPos)
  {
    delete this->startPos;

    this->startPos = new Coord(startPos);
  }

  void GlHudLine::setEndPosition(const Coord &endPos)
  {
    delete this->endPos;

    this->endPos = new Coord(endPos);
  }

  void GlHudLine::setStartColor(const Color &startColor)
  {
    delete this->startCol;

    this->startCol = new Color(startColor);
  }

  void GlHudLine::setEndColor(const Color &endColor)
  {
    delete this->endCol;

    this->endCol = new Color(endColor);
  }

  void GlHudLine::setThickness(unsigned int thickness)
  {
    this->thickness = thickness;
  }
}
