//-*-c++-*-
/*
 Author: Delorme Maxime
 Email : Maxime.Delorme@gmail.com

 Last modification : 05/08/2005 (fr) 

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#include "tulip/GlHudCircle.h"


using namespace std;

namespace tlp {

  GlHudCircle::GlHudCircle() {
  }

  GlHudCircle::GlHudCircle(const Coord &center, const Color &color, int radius, int segments):
    center(center),
    color(color),
    radius(radius),
    segments(segments) {
    computeCircle();
  }
  
  GlHudCircle::~GlHudCircle()  {
  }

  void GlHudCircle::computeCircle() {
    float delta = (2.0f * M_PI) / (float)segments;
    points.resize(segments);

    for(int i=0; i < segments; i++) {
      float deltaX = cos(i * delta) * (radius);
      float deltaY = sin(i * delta) * (radius);
      points[i] = Coord(center.getX() + deltaX, center.getY() + deltaY, center.getZ());
      points[i] = transformCoordinates(points[i]);
    }
  }

  void GlHudCircle::draw(GlGraph *graph) {
    setup();
    GLfloat *col = color.getGL();
    glColor4fv(col);
    delete col;
    glBegin(GL_LINE_STRIP);
    glLineWidth(1);
    for(int i=0; i <= segments; i++) {
	int id = i % segments;
	glVertex3d(points[id].getX(), points[id].getY(), points[id].getZ());
      }
    glEnd();
    unsetup();
  }

  Coord GlHudCircle::getCenter() {
    return center;
  }

  Color GlHudCircle::getColor() {
    return color;
  }

  int GlHudCircle::getRadius() {
    return radius;
  }

  int GlHudCircle::getSegments() {
    return segments;
  }

  void GlHudCircle::setCenter(const Coord &_center) {
    center = _center;
    computeCircle();
  }

  void GlHudCircle::setColor(const Color &_color) {
    color = _color;
  }

  void GlHudCircle::setRadius(int _radius) {
    radius = _radius;
    computeCircle();
  }

  void GlHudCircle::setSegments(int _segments) {
    segments = _segments;
    computeCircle();
  }

}
