//*********************************************************************************
//** GlADPoint.cpp : Source for an augmented display line
//** 
//** author : Delorme Maxime
//** date   : 07/07/05
//*********************************************************************************

#include "tulip/GlADLine.h"

using namespace std;
namespace tlp {

  GlADLine::GlADLine() {
    // No default constructor
  }
  //===================================================
  GlADLine::GlADLine(const Coord& startPosition, const Coord& endPosition, const Color& color, int thickness) {
    this->startPosition = new Coord(startPosition);
    this->endPosition   = new Coord(endPosition);
    this->startColor    = new Color(color);
    this->endColor      = new Color(color);
    this->thickness     = thickness;
  }
  //===================================================
  GlADLine::GlADLine(const Coord& startPosition, const Coord& endPosition, const Color& startColor, const Color& endColor, int thickness) {
    this->startPosition = new Coord(startPosition);
    this->endPosition   = new Coord(endPosition);
    this->startColor    = new Color(startColor);
    this->endColor      = new Color(endColor);
    this->thickness     = thickness;
  }
  //===================================================
  GlADLine::~GlADLine() {
    delete endPosition;
    delete endColor;
  }
  //===================================================
  void GlADLine::draw(GlGraph* graph) {
    setup();
    
    GLfloat *scol = startColor->getGL();
    GLfloat *ecol = endColor->getGL();

    glLineWidth(thickness);

    glBegin(GL_LINES);

    glColor4fv(scol);  
    glVertex3d(startPosition->getX(), startPosition->getY(), startPosition->getZ());

    glColor4fv(ecol);
    glVertex3d(endPosition->getX(), endPosition->getY(), endPosition->getZ());
    
    glEnd(); 

    unsetup();
  }

  // This is a bit redundant but for the comfort of the user
  Coord* GlADLine::getStartPosition() const
  {
    return startPosition;
  }

  Coord* GlADLine::getEndPosition() const
  {
    return endPosition;
  }

  // The same here
  Color* GlADLine::getStartColor() const
  {
    return startColor;
  }

  Color* GlADLine::getEndColor() const
  {
    return endColor;
  }

  int GlADLine::getThickness() const
  {
    return thickness;
  }

  // Still a bit redundant :)
  void GlADLine::setStartPosition(const Coord& startPosition)
  {
    delete this->startPosition;

    this->startPosition = new Coord(startPosition);
  }

  void GlADLine::setEndPosition(const Coord& endPosition)
  {
    delete this->endPosition;
    
    this->endPosition = new Coord(endPosition);
  }

  void GlADLine::setStartColor(const Color& startColor)
  {
    delete this->startColor;

    this->startColor = new Color(startColor);
  }

  void GlADLine::setEndColor(const Color& endColor)
  {
    delete this->endColor;

    this->endColor = new Color(endColor);
  }

  void GlADLine::setThickness(int thickness)
  {
    this->thickness = thickness;
  }
}
