//*********************************************************************************
//** GlADGrid.cpp : Source for a general grid display
//** 
//** author : Delorme Maxime
//** date   : 07/08/05
//********************************************************************************

#include "tulip/GlADGrid.h"

#define EPSILON 1e-06

using namespace std;

namespace tlp {
  //============================================================
  GlADGrid::GlADGrid() {
    //cout << "[START] ... " << __PRETTY_FUNCTION__ << endl;
    // no default constructor
  }
  //============================================================
  GlADGrid::GlADGrid(const Coord& frontTopLeft, const Coord& backBottomRight, const Size& cell, const Color& color, bool displayDim[3], bool hollowGrid) :
    frontTopLeft(frontTopLeft), 
    backBottomRight(backBottomRight), 
    color(color), 
    cell(cell),
    hollowGrid(hollowGrid) {
    //cout << "[START] ... " << __PRETTY_FUNCTION__ << endl;

    for(int i=0; i < 3; i++)
      this->displayDim[i] = displayDim[i];
    /*
    resetVectors();
    computeGrid();
    */
  }
  //============================================================
  GlADGrid::~GlADGrid() {
    //cout << "[START] ... " << __PRETTY_FUNCTION__ << endl;
    //    resetVectors();

    //    delete frontTopLeft;
    //    delete backBottomRight;
    //    delete cell;
  }
  //============================================================
  void GlADGrid::draw(GlGraph* graph) {
    //    cout << "Début dessin\n";
    
    Coord delta = backBottomRight - frontTopLeft;
    Coord gridSize = backBottomRight - frontTopLeft;
    delta /= gridSize / cell;
    
    glLineWidth(1);
    glBegin(GL_LINES);
    //xy-plane
    if (displayDim[0]) {
      Coord A(frontTopLeft);
      while (A[0] <= backBottomRight[0] + 1E-3) {
	glVertex3f(A[0], A[1], A[2]);
	glVertex3f(A[0], A[1] + gridSize[1] , A[2]);
	A[0] += delta[0];
      }
      A = frontTopLeft;
      while (A[1] <= backBottomRight[1] + 1E-3) {
	glVertex3f(A[0], A[1], A[2]);
	glVertex3f(A[0] + gridSize[0], A[1]  , A[2]);
	A[1] += delta[1];
      }
    }
    //yz-plane
    if (displayDim[1]) {
      Coord A(frontTopLeft);
      while (A[2] <= backBottomRight[2] + 1E-3) {
	glVertex3f(A[0], A[1], A[2]);
	glVertex3f(A[0], A[1] + gridSize[1] , A[2]);
	A[2] += delta[2];
      }
      A = frontTopLeft;
      while (A[1] <= backBottomRight[1] + 1E-3) {
	glVertex3f(A[0], A[1], A[2]);
	glVertex3f(A[0], A[1] , A[2] + gridSize[2]);
	A[1] += delta[1];
      }
    }
    //xz-plane
    if (displayDim[2]) {
      Coord A(frontTopLeft);
      while (A[2] <= backBottomRight[2] + 1E-3) {
	glVertex3f(A[0], A[1], A[2]);
	glVertex3f(A[0]+ gridSize[0], A[1]  , A[2]);
	A[2] += delta[2];
      }
      A = frontTopLeft;
      while (A[0] <= backBottomRight[0] + 1E-3) {
	glVertex3f(A[0], A[1], A[2]);
	glVertex3f(A[0], A[1], A[2] + gridSize[2]);
	A[0] += delta[0];
      }
    }
    glEnd();
  }
  //============================================================
  void GlADGrid::changeRenderOptions() {
  }
  //============================================================
  bool GlADGrid::getHollowGrid() const {
    return hollowGrid;
  }
  //============================================================
  void GlADGrid::getDisplayDim(bool displayDim[3]) const {
    for(int i=0; i < 3; i++)
      displayDim[i] = this->displayDim[i];
  }
  //============================================================
  void GlADGrid::setHollowGrid(bool hollowGrid) {
    this->hollowGrid = hollowGrid;
  }
  //============================================================
  void GlADGrid::setDisplayDim(bool displayDim[3]) {
    for(int i=0; i < 3; i++)
      this->displayDim[i] = displayDim[i];

  }

}
