//-*-c++-*-
/*
 Author: Delorme Maxime
 Email : Maxime.Delorme@gmail.com

 Last modification : 20/07/2005 (fr) 

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifndef _GLAD_RENDER_OPTIONS_H
#define _GLAD_RENDER_OPTIONS_H

#include <GL/glu.h> 
#include <tulip/Coord.h>
#include <vector>

using namespace std;

#define N_RENDERSTATES 6
namespace tlp {
enum GlADRenderState {GlAD_Wireframe, GlAD_Solid, GlAD_AlphaBlending, GlAD_ZEnable, GlAD_Lighting, GlAD_Culling}; /**< Enumeration of the different Render states*/

/** \brief Class used to manage the render state for rendering the augmented displays
 * 
 * This class is a simple class used to manage render states for the display of the GLAD
 * It mainly uses one 32-bits integer. Each bit represent a different rendering state. 
 * As you can see, this class can be improved since there is still some room in the integer :)
 */
class GlADRenderOptions {

 protected:
  int renderStatesValue; /**< The Integer used to represent the render states */

 public:
  
  /**
   * Default Constructor.
   */
  GlADRenderOptions();

  /**
   * Constructor with a given base value for the integer.
   */
  GlADRenderOptions(int baseValue);

  /**
   * Destructor
   */
  ~GlADRenderOptions();

  /**
   * Function used to  recopty a rendering option class into the current one.
   */
  void setRenderOptions(const GlADRenderOptions &renderOptions);

  /**
   * Accessor in writing to a render state.
   */
  void setRenderState(GlADRenderState renderState, bool value);

  /**
   * Accessor in reading to a render state.
   */
  bool getRenderState(GlADRenderState renderState) const;

  /**
   * Function used to setup the different render states.
   */
  void setup();
};
}
#endif
