/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.resolver.readers;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Stack;
import java.util.Vector;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogEntry;
import org.apache.xml.resolver.CatalogException;
import org.apache.xml.resolver.helpers.Debug;
import org.apache.xml.resolver.readers.CatalogReader;

public class TextCatalogReader
implements CatalogReader {
    protected InputStream catfile = null;
    protected int[] stack = new int[3];
    protected Stack tokenStack = new Stack();
    protected int top = -1;
    protected boolean caseSensitive = false;

    public void setCaseSensitive(boolean bl) {
        this.caseSensitive = bl;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void readCatalog(Catalog catalog, String string) throws MalformedURLException, IOException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new URL("file:///" + string);
        }
        URLConnection uRLConnection = uRL.openConnection();
        try {
            this.readCatalog(catalog, uRLConnection.getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Debug.message(1, "Failed to load catalog, file not found", uRL.toString());
        }
    }

    public void readCatalog(Catalog catalog, InputStream inputStream) throws MalformedURLException, IOException {
        this.catfile = inputStream;
        if (this.catfile == null) {
            return;
        }
        Vector<String> vector = null;
        while (true) {
            String string;
            if ((string = this.nextToken()) == null) {
                if (vector != null) {
                    catalog.unknownEntry(vector);
                    vector = null;
                }
                this.catfile.close();
                this.catfile = null;
                return;
            }
            String string2 = null;
            string2 = this.caseSensitive ? string : string.toUpperCase();
            try {
                int n = CatalogEntry.getEntryType(string2);
                int n2 = CatalogEntry.getEntryArgCount(n);
                Vector<String> vector2 = new Vector<String>();
                if (vector != null) {
                    catalog.unknownEntry(vector);
                    vector = null;
                }
                int n3 = 0;
                while (n3 < n2) {
                    vector2.addElement(this.nextToken());
                    ++n3;
                }
                catalog.addEntry(new CatalogEntry(string2, vector2));
                continue;
            }
            catch (CatalogException catalogException) {
                if (catalogException.getExceptionType() == 3) {
                    if (vector == null) {
                        vector = new Vector<String>();
                    }
                    vector.addElement(string);
                    continue;
                }
                if (catalogException.getExceptionType() != 2) continue;
                Debug.message(1, "Invalid catalog entry", string);
                vector = null;
                continue;
            }
            break;
        }
    }

    protected void finalize() {
        if (this.catfile != null) {
            try {
                this.catfile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.catfile = null;
    }

    /*
     * Unable to fully structure code
     */
    protected String nextToken() throws IOException {
        var1_1 = "";
        if (!this.tokenStack.empty()) {
            return (String)this.tokenStack.pop();
        }
        block0: while (true) {
            var2_2 = this.catfile.read();
            while (var2_2 <= 32) {
                var2_2 = this.catfile.read();
                if (var2_2 >= 0) continue;
                return null;
            }
            var3_3 = this.catfile.read();
            if (var3_3 < 0) {
                return null;
            }
            if (var2_2 != 45 || var3_3 != 45) break;
            var2_2 = 32;
            var3_3 = this.nextChar();
            while (true) {
                if (var2_2 == 45 && var3_3 == 45) continue block0;
                var2_2 = var3_3;
                var3_3 = this.nextChar();
            }
            break;
        }
        this.stack[++this.top] = var3_3;
        this.stack[++this.top] = var2_2;
        var2_2 = this.nextChar();
        if (var2_2 != 34 && var2_2 != 39) ** GOTO lbl41
        var4_4 = var2_2;
        while ((var2_2 = this.nextChar()) != var4_4) {
            var5_6 = new char[]{(char)var2_2};
            var6_8 = new String(var5_6);
            var1_1 = var1_1.concat(var6_8);
        }
        return var1_1;
lbl-1000:
        // 1 sources

        {
            var3_3 = this.nextChar();
            if (var2_2 == 45 && var3_3 == 45) {
                this.stack[++this.top] = var2_2;
                this.stack[++this.top] = var3_3;
                return var1_1;
            }
            var4_5 = new char[]{(char)var2_2};
            var5_7 = new String(var4_5);
            var1_1 = var1_1.concat(var5_7);
            var2_2 = var3_3;
lbl41:
            // 2 sources

            ** while (var2_2 > 32)
        }
lbl42:
        // 1 sources

        return var1_1;
    }

    protected int nextChar() throws IOException {
        if (this.top < 0) {
            return this.catfile.read();
        }
        return this.stack[this.top--];
    }
}

