#include <time.h>
#include <tulip/TulipPlugin.h>
#include <tulip/StableIterator.h>

using namespace std;



namespace {

  const char * paramHelp[] =
    {
      // minsize
      HTML_HELP_OPEN() \
      HTML_HELP_DEF( "type", "int" ) \
      HTML_HELP_DEF( "default", "100" ) \
      HTML_HELP_BODY() \
      "This parameter defines the minimal amount of node used to build the randomized tree." \
      HTML_HELP_CLOSE(),

      // maxsize
      HTML_HELP_OPEN() \
      HTML_HELP_DEF( "type", "int" ) \
      HTML_HELP_DEF( "default", "1000" ) \
      HTML_HELP_BODY() \
      "This parameter defines the maximal amount of node used to build the randomized tree." \
      HTML_HELP_CLOSE(),
    };
}

struct RandomTree:public ImportModule {
  RandomTree(ClusterContext context):ImportModule(context) {
    addParameter<int>("minsize",paramHelp[0],"100");
    addParameter<int>("maxsize",paramHelp[1],"1000");
  }
  ~RandomTree() {
  }

  bool buildNode(node n,int sizeM) {
    if (superGraph->numberOfNodes()>sizeM+2) return false;
    bool result=true;
    int randNumber=rand();
    if (randNumber>RAND_MAX/2) {
      node n1,n2;
      n1=superGraph->addNode();
      n2=superGraph->addNode();
      superGraph->addEdge(n,n1);
      superGraph->addEdge(n,n2);
      result= result && buildNode(n1,sizeM);
      result= result && buildNode(n2,sizeM);
    }
    return result;
  }

  bool import(const string &name) {
    srand(clock()); 
    int minSize  = 100;
    int maxSize  = 1000;
    if (dataSet!=0) {
      dataSet->get("minsize", minSize);
      dataSet->get("maxsize", maxSize);
    }

    bool ok=true;
    int i=0;
    while (ok) {
      if (pluginProgress->progress(i%100,100)!=TLP_CONTINUE) break;
      i++;
      superGraph->clear();
      node n=superGraph->addNode();
      ok = !buildNode(n,maxSize);
      if (superGraph->numberOfNodes()<minSize-2) ok=true;
    }
    return pluginProgress->progress(100,100)!=TLP_CANCEL;
  }
};
IMPORTPLUGIN(RandomTree,"Uniform Random Binary Tree","Auber","16/02/2001","0","0","1")
