//-*-c++-*-

#include "tulip/MethodFactory.h"
#include "tulip/StringProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/String.h"
#include "tulip/PropertyProxy.h"

using namespace std;

StringProxy::StringProxy (SuperGraph *graph):PropertyProxy<StringType,StringType, String>(graph) {
  //  propertyProxy=this;
}
  
StringProxy::~StringProxy() {
}

void StringProxy::reset_handler() {
}

//=============================================================================
void StringProxy::recompute_handler() {
  //  superGraph->getPropertyManager()->currentPropertyProxy=this;
}

//=================================================================================
PProxy* StringProxy::clonePrototype(SuperGraph * g, std::string n)
{
	if( !g )
		return 0;
	StringProxy * p = g->getLocalProperty<StringProxy>( n );
	p->setAllNodeValue( getNodeDefaultValue() );
	p->setAllEdgeValue( getEdgeDefaultValue() );
	return p;
}
//=============================================================
void StringProxy::copy( const node n0, const node n1, PProxy * p )
{
	if( !p )
		return;
	StringProxy * tp = dynamic_cast<StringProxy*>(p);
	assert( tp );
	setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void StringProxy::copy( const edge e0, const edge e1, PProxy * p )
{
	if( !p )
		return;
	StringProxy * tp = dynamic_cast<StringProxy*>(p);
	assert( tp );
	setEdgeValue( e0, tp->getEdgeValue(e1) );
}


