#include "tulip/PluginsCreation.h"

#ifdef _WIN32
#include <windows.h>
#else
#include <dlfcn.h>
#endif

#ifdef _WIN32
func
loadWin32plugin(const std::string & filename,PluginLoader *loader) {
  HINSTANCE hDLL = LoadLibrary(filename.c_str());
  if (hDLL == NULL) { 
    if (loader!=0) 
      loader->aborted(filename, "Error during the plugin loading");
    return NULL;
  }
  func createObj = (func)GetProcAddress(hDLL, "_creator"); 
  if (!createObj) { 
    if (loader!=0) 
      loader->aborted(filename, "Error : no function _creator");
    FreeLibrary(hDLL);                        			
    return NULL;
  }
return createObj;
}

#else

func
loadUnixPlugin(const std::string &filename, PluginLoader *loader) {
  char *error;
  void *handle = dlopen (filename.c_str() , RTLD_NOW);
  if (!handle) { 
    if (loader!=0) 
      loader->aborted(filename, std::string(dlerror()));
    return NULL;
  }
  func createObj =(func) dlsym(handle, "_creator");
  if ((error=dlerror())!=0) {
    dlclose(handle);
    if (loader!=0) 
      loader->aborted(filename, std::string(error));
    return NULL;
  }
  return createObj;
}
#endif

func 
getCreationFunc(const std::string &filename, PluginLoader *loader) {
#ifdef _WIN32
  return loadWin32plugin(filename, loader);
#else
  return loadUnixPlugin(filename, loader);
#endif
}
