//-*-c++-*-
#ifndef TULIP_SUPERGRAPHABSTRACT_H
#define TULIP_SUPERGRAPHABSTRACT_H

#include <set>
#include "SuperGraph.h"
#include "Reflect.h"

class PropertyManager;
class SelectionProxy;
template<class C>class Iterator;

///Abstract class for default graph operations.
class SuperGraphAbstract:public SuperGraph {
public:
  SuperGraphAbstract(SuperGraph *father=0);
  virtual ~SuperGraphAbstract();
  virtual void clear();
  virtual SuperGraph *addSubGraph(SelectionProxy *selectionProxy=0);
  virtual void delSubGraph(SuperGraph *);
  virtual void delAllSubGraphs(SuperGraph *);
  virtual SuperGraph* getFather()const;
  virtual SuperGraph* getRoot() const;
  virtual Iterator<SuperGraph *> * getSubGraphs() const;

  //=======================================
  virtual unsigned int deg(const node) const;
  virtual unsigned int indeg(const node) const;
  virtual unsigned int outdeg(const node) const;
  virtual node source(const edge) const;
  virtual node target(const edge) const;
  virtual node opposite(const edge, const node)const;
  virtual edge existEdge(const node , const node)const;
  virtual void reverse(const edge);
  //=======================================
  virtual node getOneNode() const;
  virtual node getInNode(const node,unsigned int ) const;
  virtual node getOutNode(const node,unsigned int ) const;
  virtual edge getOneEdge() const;
  virtual unsigned int numberOfNodes() const;
  virtual unsigned int numberOfEdges() const;
  DataSet & getAttributes() {return attributes;}
  //========================================
  PropertyManager *getPropertyManager();
  bool existProperty(const std::string&);
  bool existLocalProperty(const std::string&);
  void delLocalProperty(const std::string&);
  Iterator<std::string>* getLocalProperties();
  Iterator<std::string>* getInheritedProperties();
  Iterator<std::string>* getProperties();
  PProxy* getProperty(const std::string &);

protected:
  void setFather(SuperGraph *);

private:
  DataSet attributes;
  SuperGraph *father;
  std::set<SuperGraph *> subgraphs;
  PropertyManager *propertyContainer;
};

#endif
