#ifndef CLUSTERTREE_H
#define CLUSTERTREE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qpoint.h>
#include <tulip/tulipconf.h>
#include "ClusterTreeData.h"

class SuperGraph;
class QListViewItem;
class QListView;
class QPopupMenu;

class TLP_QT_SIMPLE_SCOPE ClusterTree : public ClusterTreeData
{ 
  Q_OBJECT;
  
public:
  ClusterTree(SuperGraph *rootGraph, QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
  ClusterTree(QWidget* parent = 0, const char *name = 0, WFlags fl = 0);
  ~ClusterTree();
  SuperGraph *getSuperGraph() const;
  QPopupMenu *getContextMenu() const;
  
public slots:
  void update();
  void contextRemoveCluster();
  void contextRemoveAllCluster();
  void contextCloneSubgraphCluster();
  void contextMoveUpCluster();
  void contextRenameCluster();
  void contextCloneCluster();
  void setSuperGraph(SuperGraph *);
  void currentSuperGraphChanged(const SuperGraph *);
  void setRootSuperGraph(SuperGraph *);
  void rightButtonClusterTree(QListViewItem *item, const QPoint &p, int c);
  void changeSuperGraph(QListViewItem *item,const QPoint &p, int i);
  void changeSuperGraph(QListViewItem *item);
  void setContextMenu(QPopupMenu *);
  
signals:
  void aboutToRemoveView(SuperGraph *);
  void aboutToRemoveAllView(SuperGraph *);
  void supergraphChanged(SuperGraph *);
  
public:
    //fields
    SuperGraph *_currentSuperGraph, *_rootSuperGraph;
    
protected:
  void buildTreeView(QListView *item,SuperGraph *p);
  void buildTreeView(QListViewItem *item,SuperGraph *p);
  void removeSubgraph(SuperGraph *graph, bool recursive);

private:
  bool removeOperation;
  QPopupMenu *contextMenu;

};
#endif // CLUSTERTREE_H
