#include <stdio.h>
#include <math.h>
#include <sstream>

#include <tulip/SuperGraph.h>
#include <tulip/SelectionProxy.h>

#include "EqualValueClustering.h"

CLUSTERINGPLUGIN(EqualValueClustering,"Equal Value","David Auber","13/06/2001","Alpha","0","1");

using namespace std;
//================================================================================
EqualValueClustering::EqualValueClustering(ClusterContext context):Clustering(context)
{}
//================================================================================
EqualValueClustering::~EqualValueClustering()
{}

namespace stdext {
  struct hash<double> {
    size_t operator()(const double s) const { return (size_t)s; }
  };
};

//===============================================================================
bool EqualValueClustering::run() {
  string tmp1,tmp2;
  //  PropertyManager *ppC=superGraph->getPropertyManager();
  MetricProxy *metric=superGraph->getProperty<MetricProxy>("viewMetric");
  
  stdext::hash_map<double,int> partitions;
  int curPart=0;
  Iterator<node> *itN=superGraph->getNodes();
  while (itN->hasNext()) {
    double tmp=metric->getNodeValue(itN->next());
    if (partitions.find(tmp)==partitions.end()) {
      partitions[tmp]=curPart;
      curPart++;
    }
  } delete itN;
  
  //  SelectionProxy *selection =superGraph->getLocalProperty<SelectionProxy>("tmp select");
  //  selection->setAllNodeValue(false);
  //  selection->setAllEdgeValue(false);
  map <int,SuperGraph *> newClusters;
  char str[100];
  for (int i=0;i<curPart;++i) {
    sprintf(str,"Cluster_%05i",i);
    //    newClusters[i]=superGraph->addSubGraph(selection);
    newClusters[i]=superGraph->addSubGraph();
    newClusters[i]->setAttribute("name",string(str));
  }
  
  itN=superGraph->getNodes();
  while (itN->hasNext()) {
    node itn=itN->next();
    double tmp=metric->getNodeValue(itn);
    newClusters[partitions[tmp]]->addNode(itn);
  }delete itN;

  Iterator<edge> *itE=superGraph->getEdges();
  while(itE->hasNext()) {
    edge ite=itE->next();
    double tmp;
    if ((tmp=metric->getNodeValue(superGraph->source(ite)))==metric->getNodeValue(superGraph->target(ite))) {
      newClusters[partitions[tmp]]->addEdge(ite);
    }
  }delete itE;

  //  ppC->delLocalProperty("tmp select");
  return true;
}
//================================================================================
bool EqualValueClustering::check(string &erreurMsg) {
  erreurMsg="";
  return true;
}
//================================================================================
void EqualValueClustering::reset() {
}
//================================================================================




