//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "tulip/Types.h"
#include "tulip/SuperGraph.h"
using namespace std;



namespace
{

	int nocase_cmp(const string & s1, const string& s2) 
	{
	  string::const_iterator it1=s1.begin();
	  string::const_iterator it2=s2.begin();
	
	  //stop when either string's end has been reached
	  while ( (it1!=s1.end()) && (it2!=s2.end()) ) 
	  { 
	    if(::toupper(*it1) != ::toupper(*it2)) //letters differ?
	     // return -1 to indicate smaller than, 1 otherwise
	      return (::toupper(*it1)  < ::toupper(*it2)) ? -1 : 1; 
	    //proceed to the next character in each string
	    ++it1;
	    ++it2;
	  }
	  size_t size1=s1.size(), size2=s2.size();// cache lengths
	   //return -1,0 or 1 according to strings' lengths
	    if (size1==size2) 
	      return 0;
	    return (size1<size2) ? -1 : 1;
	}

	bool isempty(const string & s1) {
		int s = s1.size();
		if( s == 0 )
			return true;
		for( uint i = 0 ; i < s ; i++ ) {
			if( !isspace(s1[i]) )
				return false;
		}
		return true;
	}

}




//
// MetaGraphType

MetaGraphType::RealType
MetaGraphType::undefineValue()
{
	return 0;
}

MetaGraphType::RealType
MetaGraphType::defaultValue()
{
	return 0;
}

void
MetaGraphType::del(MetaGraphType::RealType element)
{}

std::string
MetaGraphType::toString( const RealType & v )
{
	// NULL ?
	if( !v )
		return std::string();
	std::ostringstream oss;
	oss << v->getId();
	return oss.str();
}

bool
MetaGraphType::fromString( RealType & v, const std::string & s )
{
  v = 0;
  return false;
}


//
// DoubleType

double
DoubleType::undefineValue()
{
	return DBL_MIN;
}

double
DoubleType::defaultValue()
{
	return 0;
}

void
DoubleType::del(DoubleType::RealType element)
{
}

std::string
DoubleType::toString( const RealType & v )
{
	std::ostringstream oss;
	oss << v;
	return oss.str();
}

bool
DoubleType::fromString( RealType & v, const std::string & s )
{
	std::istringstream iss;
	iss.str( s );
	return (iss >> v);
}



//
// IntType

int
IntType::undefineValue()
{
	return INT_MIN;
}

int
IntType::defaultValue()
{
	return 0;
}

void
IntType::del(IntType::RealType element)
{
}

std::string
IntType::toString( const RealType & v )
{
	std::ostringstream oss;
	oss << v;
	return oss.str();
}

bool
IntType::fromString( RealType & v, const std::string & s )
{
	std::istringstream iss;
	iss.str( s );
	return (iss >> v);
}



//
// BooleanType

bool
BooleanType::undefineValue()
{
	return false;
}

bool
BooleanType::defaultValue()
{
	return false;
}

void
BooleanType::del(BooleanType::RealType element)
{
}

std::string
BooleanType::toString( const RealType & v )
{
	return v ? std::string("true") : std::string("false");
}

bool
BooleanType::fromString( RealType & v, const std::string & s )
{
	if( nocase_cmp(s,"false")==0 ) {
		v = false;
		return true;
	}
	else if( nocase_cmp(s,"true")==0 ) {
		v = true;
		return true;
	}
	return false;
}



//
// LineType

std::vector<Coord>
LineType::undefineValue()
{
    std::vector<Coord> tmp;
    return tmp;
}

std::vector<Coord>
LineType::defaultValue()
{
	std::vector<Coord> tmpList;
	return tmpList;
}

void
LineType::del(LineType::RealType &element)
{
	element.clear();
}

std::string
LineType::toString( const RealType & v )
{
	std::ostringstream oss;
	oss << '(';
	for( uint i = 0 ; i < v.size() ; i++ )
		oss << v[i];
	oss << ')';
	return oss.str();
}

bool
LineType::fromString( RealType & v, const std::string & s )
{
	v.clear();
	std::istringstream iss;
	iss.str( s );
	char c;
	if( !(iss >> c) || c!='(' )
		return false;
	Coord co;
	for( ;; ) {
		if( !(iss >> c) )
			return false;
		if( c == ')' )
			return true;
		iss.unget();
		if( !(iss >> co) )
			return false;
		v.push_back( co );
	}
}



//
// PointType

Coord
PointType::undefineValue()
{
	Coord tmp;
	tmp.set(DBL_MIN,DBL_MIN,DBL_MIN);
	return tmp;
}

Coord
PointType::defaultValue()
{
	Coord tmp;
    tmp.set(rand()%1024,rand()%1024,rand()%1024);
    return tmp;
}

void
PointType::del(PointType::RealType element)
{
}

std::string
PointType::toString( const RealType & v )
{
	std::ostringstream oss;
	oss << v;
	return oss.str();
}

bool
PointType::fromString( RealType & v, const std::string & s )
{
	std::istringstream iss;
	iss.str( s );
	return (iss >> v);
}



//
// SizeType

Size
SizeType::undefineValue()
{
	return Size(DBL_MIN,DBL_MIN,DBL_MIN);
}

Size
SizeType::defaultValue()
{
    return Size(1,1,0);
}

void
SizeType::del(SizeType::RealType element)
{}

std::string
SizeType::toString( const RealType & v )
{
	std::ostringstream oss;
	oss << v;
	return oss.str();
}

bool
SizeType::fromString( RealType & v, const std::string & s )
{
	std::istringstream iss;
	iss.str( s );
	return (iss >> v);
}



//
// StringType

std::string
StringType::undefineValue()
{
	return std::string("");
}

std::string
StringType::defaultValue()
{
	return std::string("");
}

void
StringType::del(StringType::RealType element)
{
}

std::string
StringType::toString( const RealType & v )
{
  	return std::string( v );
}

bool
StringType::fromString( RealType & v, const std::string & s )
{
	v = s;
  	return true;
}



//
// ColorType

Color
ColorType::undefineValue() 
{
	return Color(255,255,255,255);
}

Color
ColorType::defaultValue()
{
	return Color();
}

void
ColorType::del(ColorType::RealType element)
{
}

std::string
ColorType::toString( const RealType & v )
{
	std::ostringstream oss;
	oss << v;
	return oss.str();
}

bool
ColorType::fromString( RealType & v, const std::string & s )
{
	std::istringstream iss;
	iss.str( s );
	return (iss >> v);
}


