//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <float.h>
#include "tulip/SizesProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/Sizes.h"
#include "tulip/PropertyProxy.h"
#include "tulip/MethodFactory.h"

using namespace std;

//==============================
SizesProxy::SizesProxy (SuperGraph *graph):
  PropertyProxy<SizeType,SizeType>(graph) {
  //  propertyProxy=this;
}
//==============================
SizesProxy::~SizesProxy() {
}    
//====================================================================
void SizesProxy::reset_handler() {
}
//=============================================================================
void SizesProxy::recompute_handler() {
  //  superGraph->getPropertyManager()->currentPropertyProxy=this;
}
//=============================================================================
Size SizesProxy::getMax(SuperGraph *sg) {
  if (sg==0) sg=superGraph;
  int sgi=(int)sg;
  if (minMaxOk.find(sgi)==minMaxOk.end()) minMaxOk[sgi]=false;
  if (!minMaxOk[sgi]) computeMinMax(sg);
  return max[sgi];
}
//=============================================================================
Size  SizesProxy::getMin(SuperGraph *sg) {
  if (sg==0) sg=superGraph;
  int sgi=(int)sg;
  if (minMaxOk.find(sgi)==minMaxOk.end()) minMaxOk[sgi]=false;
  if (!minMaxOk[sgi]) computeMinMax(sg);
  return min[sgi];
}
//=============================================================================
void SizesProxy::computeMinMax(SuperGraph *sg) {
#ifndef NDEBUG
  cerr << "SizeqProxy::computeMinMax begin" << endl;
#endif

  Size tmpSize;
  Size maxS,minS;

  Iterator<node> *itN=sg->getNodes();
  if  (itN->hasNext()) {
    node itn=itN->next();
    tmpSize=getNodeValue(itn);
    for (int i=0;i<3;++i) {
      maxS[i]=tmpSize[i];
      minS[i]=tmpSize[i];
    }
  }
  while (itN->hasNext()) {
    node itn=itN->next();
    tmpSize=getNodeValue(itn);
    for (int i=0;i<3;++i) {
      maxS[i]=maxS[i]>?tmpSize[i];
      minS[i]=minS[i]<?tmpSize[i];
    }
  }delete itN;

  if (sg==0) sg=superGraph;
  int sgi=(int)sg;

  minMaxOk[sgi]=true;  
  min[sgi]=minS;
  max[sgi]=maxS;
  //  cerr << "SizesProxy::computeMinMax end" << endl;
}
//=============================================================================
void SizesProxy::resetMinMax() {
  stdext::hash_map<int,bool>::iterator it;
  for (it=minMaxOk.begin();it!=minMaxOk.end();++it)
    it->second=false;
}
//=============================================================================
void SizesProxy::setNodeValue_handler(const node n){resetMinMax();}
//=============================================================================
void SizesProxy::setEdgeValue_handler(const edge e){resetMinMax();}
//=============================================================================
void SizesProxy::setAllNodeValue_handler(){resetMinMax();}
//=============================================================================
void SizesProxy::setAllEdgeValue_handler(){resetMinMax();}
//=============================================================================

//=================================================================================
PProxy* SizesProxy::clonePrototype(SuperGraph * g, std::string n)
{
	if( !g )
		return 0;
	SizesProxy * p = g->getLocalProperty<SizesProxy>( n );
	p->setAllNodeValue( getNodeDefaultValue() );
	p->setAllEdgeValue( getEdgeDefaultValue() );
	return p;
}
//=============================================================
void SizesProxy::copy( const node n0, const node n1, PProxy * p )
{
	if( !p )
		return;
	SizesProxy * tp = dynamic_cast<SizesProxy*>(p);
	assert( tp );
	setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void SizesProxy::copy( const edge e0, const edge e1, PProxy * p )
{
	if( !p )
		return;
	SizesProxy * tp = dynamic_cast<SizesProxy*>(p);
	assert( tp );
	setEdgeValue( e0, tp->getEdgeValue(e1) );
}


