//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "tulip/MethodFactory.h"
#include "tulip/SelectionProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/Selection.h"
#include "tulip/PropertyProxy.h"

using namespace std;

//=================================================================================
SelectionProxy::SelectionProxy (SuperGraph *graph):PropertyProxy<BooleanType,BooleanType>(graph) {
  //  propertyProxy=this;
}
//=================================================================================
SelectionProxy::~SelectionProxy() {
}  
//=================================================================================
///Poign� permettnet le reset des variables du MetricProxy par le PropertyProxy
void SelectionProxy::reset_handler() {
}
//=============================================================================
///Poign� permettnet le recompute il faut absolument mettre le graphProperties
///currentMetricProxy � this sinon le r�sultat est impr�visible
void SelectionProxy::recompute_handler() {
  //  superGraph->getPropertyManager()->currentPropertyProxy=this;
}
//=================================================================================
//Fonctionnalit� suppl�mentaire ajout� au seletion Proxy
void SelectionProxy::reverse() {
  Observable::holdObservers();
  Iterator<node> *itN=superGraph->getNodes();
  while (itN->hasNext()) {
    node itn=itN->next();
    if (getNodeValue(itn)==true)
      setNodeValue(itn,false);
    else
      setNodeValue(itn,true);
  } delete itN;
  Iterator<edge> *itE=superGraph->getEdges();
  while (itE->hasNext()) {
    edge ite=itE->next();
    if (getEdgeValue(ite)==true)
      setEdgeValue(ite,false);
    else
      setEdgeValue(ite,true);
  } delete itE;
  notifyObservers();
  Observable::unholdObservers();
}
//=================================================================================
void SelectionProxy::reverseEdgeDirection() {
  Iterator<edge> *itE=superGraph->getEdges();
  while (itE->hasNext()) {
    edge ite=itE->next();
    if (getEdgeValue(ite))
      superGraph->reverse(ite);
  } delete itE;
}
//=================================================================================
PProxy* SelectionProxy::clonePrototype(SuperGraph * g, std::string n)
{
	if( !g )
		return 0;
	SelectionProxy * p = g->getLocalProperty<SelectionProxy>( n );
	p->setAllNodeValue( getNodeDefaultValue() );
	p->setAllEdgeValue( getEdgeDefaultValue() );
	return p;
}
//=============================================================
void SelectionProxy::copy( const node n0, const node n1, PProxy * p )
{
	if( !p )
		return;
	SelectionProxy * tp = dynamic_cast<SelectionProxy*>(p);
	assert( tp );
	setNodeValue( n0, tp->getNodeValue(n1) );
}
//=============================================================
void SelectionProxy::copy( const edge e0, const edge e1, PProxy * p )
{
	if( !p )
		return;
	SelectionProxy * tp = dynamic_cast<SelectionProxy*>(p);
	assert( tp );
	setEdgeValue( e0, tp->getEdgeValue(e1) );
}



