#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "tulip/MapIterator.h"

NodeMapIterator::NodeMapIterator(SuperGraph *sg, node source, node target) {
  assert(cloneIt.empty());
  bool start=true;
  Iterator<node> *itIn=sg->getInOutNodes(target);
  while (itIn->hasNext()) {
    node tmp=itIn->next();
    if ((start) && (tmp==source)) {
      start=false;
      itStl=cloneIt.begin();
    }
    else {
      if (start)
	cloneIt.push_back(tmp);
      else 
	cloneIt.insert(itStl,tmp);
    }
  } delete itIn;
  itStl=cloneIt.begin();
}

NodeMapIterator::~NodeMapIterator(){};

node NodeMapIterator::next() {
  node tmp=*itStl;
  ++itStl;
  return tmp;
}

bool NodeMapIterator::hasNext() {
  return (itStl!=cloneIt.end());
}

//=========================================

EdgeMapIterator::EdgeMapIterator(SuperGraph *sg, edge source, node target) {
  assert(cloneIt.empty());
  bool start=true;
  Iterator<edge> *itIn=sg->getInOutEdges(target);
  for (;itIn->hasNext();) {
    edge tmp=itIn->next();
    if (start && tmp==source) {
      start=false;
      itStl=cloneIt.begin();
    }
    else {
      if (start)
	cloneIt.push_back(tmp);
      else 
	cloneIt.insert(itStl,tmp);
    }
  } delete itIn;
  itStl=cloneIt.begin();
}

EdgeMapIterator::~EdgeMapIterator(){}

edge EdgeMapIterator::next() {
  edge tmp=*itStl;
  ++itStl;
  return tmp;
}

bool EdgeMapIterator::hasNext() {
  return (itStl!=cloneIt.end());
}
