#include "tulip/Paragraph.h"
#include "tulip/DynamicFunctions.h"

#include <string.h>
#include <iostream>
#include <cassert>

#define H 3

using namespace std;

//***************************************************************************
// CLASSE C_String
//***************************************************************************
//---------------------------------------------------------------------------
C_String::C_String(string str, Context* ctr):c(ctr),s(str){
}

C_String::C_String(const C_String& c_s):c(c_s.c),s(c_s.getString()){
}
//***************************************************************************
// CLASSE Paragraph
//***************************************************************************
//---------------------------------------------------------------------------
Paragraph::Paragraph(Align a) {
  alignement = a;
}
Paragraph::~Paragraph(){
  for(unsigned int i = 0; i<listOfcontexts.size(); ++i){
    delete listOfcontexts[i];
  }
}

//---------------------------------------------------------------------------
void Paragraph::drawLeft(float w_max, float x_depl, int debut, int fin) const{
  DynamicFunctions* myRendu = DynamicFunctions::create();
  
  int j, val;
  float decal= 0;
  Context* c_current;
  for(j = debut; j<=fin; j++){  // on affiche chaque mot sur la ligne
    c_current = myString.at(j).getContext();
    
    val = myRendu->fonts->searchFont(myRendu->mode, c_current->getSize(),c_current->getFontName(), myRendu->depth);
    assert(val != -1);
    
    unsigned char r, v, b;
    c_current->getColor(r, v, b);
    myRendu->setColor(r, v, b);
    
    myRendu->fonts->ActiveFont(val);
    if(myString.at(j).getString() != ""){
       myRendu->fonts->drawString(myString.at(j).getString());
       decal = myRendu->fonts->getAdvance(myString.at(j).getString().c_str());
    }
    myRendu->translate(decal, 0, 0);
  }      
}

//---------------------------------------------------------------------------
void Paragraph::drawRight(float w_max, float x_depl, int debut, int fin) const{
  int j, val;
  float decal= 0;
  Context* c_current;

  DynamicFunctions* myRendu = DynamicFunctions::create();
  myRendu->translate(w_max - x_depl, 0, 0);
  
  for(j = debut; j<=fin; j++){  // on affiche chaque mot sur la ligne
    c_current = myString.at(j).getContext();

    val = myRendu->fonts->searchFont(myRendu->mode, c_current->getSize(), c_current->getFontName(), myRendu->depth);
    assert(val != -1);
    
    unsigned char r, v, b;
    c_current->getColor(r, v, b);
    myRendu->setColor(r, v, b);
    
    myRendu->fonts->ActiveFont(val);
    if(myString.at(j).getString() != ""){
      myRendu->fonts->drawString(myString.at(j).getString());
      decal = myRendu->fonts->getAdvance(myString.at(j).getString().c_str());
    }
    myRendu->translate(decal,0,0);
  }  

  myRendu->translate(-(w_max - x_depl), 0, 0);
}

//---------------------------------------------------------------------------
void Paragraph::drawCenter(float w_max, float x_depl, int debut, int fin) const{
  int j, val;
  float decal= 0;
  Context* c_current;

  DynamicFunctions* myRendu = DynamicFunctions::create();
  myRendu->translate((w_max - x_depl)/2., 0, 0);
  
  for(j = debut; j<=fin; j++){  // on affiche chaque mot sur la ligne
    c_current = myString.at(j).getContext();

    val = myRendu->fonts->searchFont(myRendu->mode, c_current->getSize(), c_current->getFontName(), myRendu->depth);
    assert(val != -1);
    
    unsigned char r, v, b;
    c_current->getColor(r, v, b);
    myRendu->setColor(r, v, b);
    
    myRendu->fonts->ActiveFont(val);
    if(myString.at(j).getString() != ""){
      myRendu->fonts->drawString(myString.at(j).getString());
      decal = myRendu->fonts->getAdvance(myString.at(j).getString().c_str());
    }
    myRendu->translate(decal,0,0);
  }  
  myRendu->translate(-(w_max - x_depl)/2., 0, 0);
}

//---------------------------------------------------------------------------
void Paragraph::draw(float w_max, float& w) const{
  w = 0;
  
  DynamicFunctions* myRendu = DynamicFunctions::create();

  int n = myString.size(); // nb de chaines à traiter
  int val; // valeur contenant l'identifiant de la police
  int i_deb=0, i, taille=1; // i_deb : contient l'indice du premier mot à afficher
  bool do_test=false;
  float maxHeightSup=0, maxHeightInf=0, x_depl=0; // x_depl : longueur à afficher
  float HeightSup=0, HeightInf=0; // hauteur pour un mot
  string s;
  float size_s=0, cumul_s = 0;
  Context* c_current = 0;
  
  for(i=0; i< n; i++){
    c_current = myString.at(i).getContext();
    // recherche de la police
    val = myRendu->fonts->searchFont(myRendu->mode, c_current->getSize(), c_current->getFontName(), myRendu->depth);
    if(val == -1) // jout de la police si elle n'existe pas
      val = myRendu->fonts->AddFont(myRendu->mode, c_current->getSize(), c_current->getFontName(), myRendu->depth);
    s = myString.at(i).getString(); // on récupère le mot;

    if(s != ""){
      cumul_s += myRendu->fonts->getAdvance(s.c_str(), val); // on recherche sa longueur
            
      int length_s = s.size();
      if(s[length_s-1] == ' ')
	do_test = true;
      else{
	do_test = false;
	taille++;
      }
    }
    else
      do_test = true;
      
    if(HeightSup<myRendu->fonts->getAscender(val))
      HeightSup = myRendu->fonts->getAscender(val);
    if(HeightInf<abs(myRendu->fonts->getDescender(val)))
      HeightInf = abs(myRendu->fonts->getDescender(val));

    if(do_test){
      size_s = cumul_s;
      if((x_depl + size_s <= w_max) && (s != "")){ // test si la longeur cumulée va dépasser
	if(maxHeightSup<HeightSup) maxHeightSup = HeightSup;
	if(maxHeightInf<HeightInf) maxHeightInf = HeightInf;
	x_depl += size_s;
      }
      else{
	myRendu->translate(0,-(maxHeightSup),0); 
	float sav_inf = maxHeightInf;
	maxHeightSup =  HeightSup;
	maxHeightInf =  HeightInf;      
	switch(alignement){
	case LEFT:      drawLeft(w_max, x_depl, i_deb, i-taille);   break;
	case RIGHT:     drawRight(w_max, x_depl, i_deb, i-taille);  break;
	case CENTER:    drawCenter(w_max, x_depl, i_deb, i-taille); break;
	case JUSTIFIED: drawLeft(w_max, x_depl, i_deb, i-taille); // A FAIRE       !!!!!!!!!!!!!!!!!!!!!!!!!!!
	}
	// retour à la ligne
	myRendu->translate(-x_depl,-(sav_inf+H),0);
	if(x_depl > w) w = x_depl;	
	i_deb = i-taille+1; // maj du valeur
	x_depl = size_s;
      }
      taille = 1;
      cumul_s = 0;
      HeightSup = 0;
      HeightInf = 0;
    }
  }
  
  // derniere ligne à afficher ou première s'il y en a eu qu'une ...
  myRendu->translate(0,-(maxHeightSup),0);
  
  switch(alignement){
  case LEFT:      drawLeft(w_max, x_depl, i_deb, n-1);    break;
  case RIGHT:     drawRight(w_max, x_depl, i_deb, n-1);   break;
  case CENTER:    drawCenter(w_max, x_depl, i_deb, n-1);  break;
  case JUSTIFIED: drawLeft(w_max, x_depl, i_deb, i-1); // A FAIRE         !!!!!!!!!!!!!!!!!!!!!!!!!!!
  }
  
  // retour à la ligne
  myRendu->translate(-x_depl,-(maxHeightInf+H),0);
  if(x_depl > w) w = x_depl;
}

//---------------------------------------------------------------------------
void Paragraph::getBoundingBox(float w_max, float& h, float& w) const{
  w = 0;
  h = 0;
  DynamicFunctions* myRendu = DynamicFunctions::create();
  int n = myString.size(); // nb de chaines à traiter
  int val; // valeur contenant l'identifiant de la police
  int i_deb=0, i, taille=1; // i_deb : contient l'indice du premier mot à afficher
  bool do_test=false;
  float maxHeightSup=0, maxHeightInf=0, x_depl=0; // x_depl : longueur à afficher
  float HeightSup=0, HeightInf=0; // hauteur pour un mot
  string s;
  float size_s=0, cumul_s = 0;
  Context* c_current = 0;
  for(i=0; i< n; i++){
    c_current = myString.at(i).getContext();
    // recherche de la police
    val = myRendu->fonts->searchFont(myRendu->mode, c_current->getSize(),c_current->getFontName(), myRendu->depth);
    if(val == -1) // ajoute de la police si elle n'existe pas
      val = myRendu->fonts->AddFont(myRendu->mode, c_current->getSize(), c_current->getFontName(), myRendu->depth);
    if (val == -1) {cerr << __PRETTY_FUNCTION__ << " ==> Add font failed" << endl;return;}
    s = myString.at(i).getString(); // on récupère le mot;
    if(s != ""){
      cumul_s += myRendu->fonts->getAdvance(s.c_str(), val); // on recherche sa longueur
      int length_s = s.size();
      if(s[length_s-1] == ' ')	do_test = true;
      else{
	do_test = false;
	taille++;
      }
    }
    else
      do_test = true;    
    if(HeightSup<myRendu->fonts->getAscender(val))
      HeightSup = myRendu->fonts->getAscender(val);
    if(HeightInf<abs(myRendu->fonts->getDescender(val)))
      HeightInf = abs(myRendu->fonts->getDescender(val));
    
    if(do_test){
      size_s = cumul_s;
      if((x_depl + size_s <= w_max) && (s != "")){ // test si la longeur cumulée va dépasser
	if(maxHeightSup<HeightSup) maxHeightSup = HeightSup;
	if(maxHeightInf<HeightInf) maxHeightInf = HeightInf;
	x_depl += size_s;

      }
      else{
	h += maxHeightSup+maxHeightInf+H; 
	maxHeightSup = HeightSup;
	maxHeightInf = HeightInf;      
	if(x_depl > w) w = x_depl;
	i_deb = i-taille+1; // maj du valeur
	x_depl = size_s;
      }
      taille = 1;
      cumul_s = 0;
      HeightSup = 0;
      HeightInf = 0;
    }
  }
  // derniere ligne à afficher ou première s'il y en a eu qu'une ...
  h += maxHeightSup+maxHeightInf+H; 
  if(x_depl > w) w = x_depl; 
}
//---------------------------------------------------------------------------
bool Paragraph::addString(string s, Context c){
  Context* ctr;
  ctr = findContext(c); 
  if(!ctr) {
    ctr = new Context(c);
    listOfcontexts.push_back(ctr);
  }
  C_String c_s = C_String(s,ctr);
  myString.push_back(c_s);
  return true;
}
//---------------------------------------------------------------------------
Context* Paragraph::findContext(Context& c){
  int n = listOfcontexts.size();
  for(int i=0; i< n; i++) {
    if(c ==  *(listOfcontexts[i]))
      return listOfcontexts[i];
  }
  return 0;
} 
