#include <cmath>
#include <tulip/Metric.h>
#include <tulip/TlpTools.h>
#include <tulip/MetricProxy.h>

using namespace std;

struct SpreadingInterpolation: public Metric {

  SpreadingInterpolation(PropertyContext *context):Metric(context){}
  ~SpreadingInterpolation(){}
  bool run () {
    bool cached,errresult;
    string errmsg;
    MetricProxy *strongComponnentDecomposition=getLocalProxy<MetricProxy>(superGraph,"StrongComponnent",cached,errresult,errmsg,pluginProgress);

    //==build of histogram
    map<int,int> histo;
    map<int,int>::iterator itHisto;
    Iterator<node> *itN=superGraph->getNodes();
    for (;itN->hasNext();) {
      node itn=itN->next();
      if ((itHisto=histo.find((int)strongComponnentDecomposition->getNodeValue(itn)))!=histo.end()) {
	(*itHisto).second++;
      }
      else {
	histo[(int)strongComponnentDecomposition->getNodeValue(itn)]=1;
      }
    }delete itN;
    //==histo ok

    //==build sub graph
    SuperGraph *newGraph=TlpTools::newSubGraph(superGraph);
    list<node> aloneNode;

    itN=superGraph->getNodes();
    for (;itN->hasNext();) {
      node itn=itN->next();
      if (histo[(int)strongComponnentDecomposition->getNodeValue(itn)]>1) 
	newGraph->addNode(itn);
      else
	if (superGraph->indeg(itn)>0) aloneNode.push_back(itn);
    }delete itN;
    
    Iterator<edge> *itE=superGraph->getEdges();
    for (;itE->hasNext();) {
      edge ite=itE->next();
      if ((histo[(int)strongComponnentDecomposition->getNodeValue(superGraph->source(ite))]!=1) &&
	  (histo[(int)strongComponnentDecomposition->getNodeValue(superGraph->source(ite))]==histo[(int)strongComponnentDecomposition->getNodeValue(superGraph->target(ite))]))
	newGraph->addEdge(ite);
    }delete itE;
    //sub graph ok

    //Compute && get spreading activation
    metricProxy->setAllNodeValue(0);
    MetricProxy *spreading=getLocalProxy<MetricProxy>(newGraph,"Spreading Activation",cached,errresult,errmsg,pluginProgress);
    itN=superGraph->getNodes();
    for (;itN->hasNext();) {
      node itn=itN->next();
      metricProxy->setNodeValue(itn,spreading->getNodeValue(itn));
    }delete itN;

    superGraph->delView(newGraph->getSubGraph());

    //compute interpolation on alone nodes
    bool stopEval=false;
    unsigned int nbIteration=0;
    unsigned int nb_iteration=superGraph->numberOfNodes();
    while (!stopEval ){ // && (nbIteration<nb_iteration)) {
      stopEval=true;
      for ( list<node>::iterator it=aloneNode.begin();it!=aloneNode.end();++it) {
	double result=0;
	itN=superGraph->getInOutNodes(*it);
	//	cerr << (*it).id << ",";
	for (;itN->hasNext();) {
	  node itn=itN->next();
	  result+=metricProxy->getNodeValue(itn);
	}delete itN;
	result/=superGraph->deg(*it);
	if (fabs(metricProxy->getNodeValue(*it)-result)>0.00001) {
	  stopEval=false;
	}
	metricProxy->setNodeValue(*it,result);
      }
      nbIteration++;
      pluginProgress->progress(nbIteration,nb_iteration);
    }
    return true;
  }
};

METRICPLUGIN(SpreadingInterpolation,"Spreading Interpolation","David Auber","18/06/2002","Ok","0","1");
