#include "LeafMetric.h"

METRICPLUGIN(LeafMetric,"Leaf","David Auber","20/12/1999","Alpha","0","1");

using namespace std;

LeafMetric::LeafMetric(PropertyContext *context):Metric(context) {}

LeafMetric::~LeafMetric() {}

double LeafMetric::getNodeValue(const node n) {
  double result=0;
  Iterator<node> *itN=superGraph->getOutNodes(n);
  for(;itN->hasNext();)  {
    node itn=itN->next();
    result+=metricProxy->getNodeValue(itn);
  }delete itN;
  if (result==0) result=1.0;
  return result;
}

bool LeafMetric::check(string &erreurMsg) {
  if (superGraph->isAcyclic())
    return true;
  else {
    erreurMsg="The Graph must be a Acyclic";
    return false;
  }
}




