#include <qinputdialog.h>
#include <tulip/MetricProxy.h>

#include "ClusterMetric.h"

METRICPLUGIN(ClusterMetric,"Cluster","David Auber","26/02/2003","Beta","0","2");

using namespace std;

ClusterMetric::ClusterMetric(PropertyContext *context):Metric(context) {
  addParameter<unsigned int>("depth");
}

ClusterMetric::~ClusterMetric() {}

double ClusterMetric::getEdgeValue(const edge e ) {
  return 0;
}

void ClusterMetric::buildSubGraph(node n,node startNode,set<node> &selected,unsigned int depth) {
  if (selected.find(n)!=selected.end()) return;
  if (n!=startNode) selected.insert(n);
  if (depth==0) return;
  Iterator<node> *itN =superGraph->getInOutNodes(n);
  for (;itN->hasNext();) 
    buildSubGraph(itN->next(),startNode,selected,depth-1);
  delete itN;
}

double ClusterMetric::getNodeValue(const node n ) {
  set<node> myTmpSet;
  buildSubGraph(n,n,myTmpSet,maxDepth);
  double nbEdge=0; //e(N_v)*2$
  for (set<node>::iterator itSN=myTmpSet.begin();itSN!=myTmpSet.end();++itSN) {
    node itn=*itSN;
    Iterator<edge> *itE=superGraph->getInOutEdges(itn);
    for (;itE->hasNext();) {
      edge ite=itE->next();
      node source=superGraph->source(ite);
      node target=superGraph->target(ite);
      if ( (myTmpSet.find(source)!=myTmpSet.end()) && (myTmpSet.find(target)!=myTmpSet.end())) {
	nbEdge++;
      }
    }delete itE;
  }
  
  double nNode=(double) myTmpSet.size(); //$|N_v|$
  if (nNode>1)
    return (double)nbEdge/(nNode*(nNode-1)); //$e(N_v)/(\frac{k*(k-1)}{2}}$
  else
    return 0;
}

bool ClusterMetric::run() {
  bool ok=false;
  maxDepth=0;
  if (dataSet!=0) dataSet->get("depth",maxDepth);
  if (maxDepth==0) {
    maxDepth = QInputDialog::getInteger(QString("Please enter depth "),
					QString("depth"), 0, 0, 1000000, 10, &ok ); 
    if (!ok) return false;
  }
  return true;
}
