#include "SpringElectrical.h"

LAYOUTPLUGIN(SpringElectrical,"Spring_Electrical","David Auber","14/01/2002","Alpha","0","1");

using namespace std;

inline double sqr(double x)
{
  return (x*x);
}

SpringElectrical::SpringElectrical(PropertyContext *context):Layout(context)
{}

SpringElectrical::~SpringElectrical() {}

bool SpringElectrical::run()
{
  double width   = 100;
  double height  = 100;
  double depth   = 100;
  int iterations = superGraph->numberOfNodes();
  LayoutProxy* inputLayout=getProxy<LayoutProxy>(superGraph,"viewLayout");
  Iterator<node> *itN=superGraph->getNodes();
  for(;itN->hasNext();){
    node v=itN->next();
    layoutProxy->setNodeValue(v,inputLayout->getNodeValue(v));
  }delete itN;

  LayoutProxy *disp=getLocalProxy<LayoutProxy>(superGraph,"dispSpring");
  double k = sqrt(width*height / superGraph->numberOfNodes());
  double kSquare= sqr(k);

  for (int count = 1; count < iterations; ++count) {
    if (pluginProgress->progress(count,iterations)==false) break;
    float l2 = 50*log(1.0+count)/log(2.0);
    Coord t(width/l2,height/l2,depth/l2);
    disp->setAllNodeValue(Coord(0,0,0));
    // repulsive forces
    Iterator<node> *itN=superGraph->getNodes();
    for(;itN->hasNext();){
      node v=itN->next();
      Coord vCoord = layoutProxy->getNodeValue(v);
      Iterator<node> *itN1=superGraph->getInOutNodes(v);
      for(;itN1->hasNext();){
	node u=itN1->next();
	if (u == v) continue;
	Iterator<node> *itN2=superGraph->getInOutNodes(u);
	for(;itN2->hasNext();){
	  node u=itN2->next();
	  if (u == v) continue;
	  Coord vdist=vCoord-layoutProxy->getNodeValue(u);
	  double dist = vdist*vdist;
	  if (dist < 1e-3) dist = 1e-3;
	  vdist*=kSquare/dist;
	  disp->setNodeValue(v, disp->getNodeValue(v)+=vdist);
	  disp->setNodeValue(u, disp->getNodeValue(u)-=vdist);
	}delete itN2;
      }delete itN1;
    }delete itN;
     
    // attractive forces
    Iterator<edge> *itE=superGraph->getEdges();
    for(;itE->hasNext();) {
      edge e=itE->next();
      node u = superGraph->source(e);
      node v = superGraph->target(e);
      Coord vCoord = layoutProxy->getNodeValue(v);
      Coord uCoord = layoutProxy->getNodeValue(u);
      Coord vdist=vCoord-uCoord;
      double dist=vdist.norm();
      double f = (superGraph->deg(u)+superGraph->deg(v))/16.0;
      dist /= f;
      Coord cV(disp->getNodeValue(v));
      Coord cU(disp->getNodeValue(u));
      vdist*=dist/k;
      cV-=vdist;
      cU+=vdist;
      disp->setNodeValue(v,cV);
      disp->setNodeValue(u,cU);
    }delete itE;
   
    // preventions
    itN=superGraph->getNodes();
    for(;itN->hasNext();){
      node v=itN->next();
      Coord d=disp->getNodeValue(v);
      //d *= 1.0-((double)count/(double)iterations); // t/d.norm();
      d *= t/d.norm();
      layoutProxy->setNodeValue(v,layoutProxy->getNodeValue(v)+=d);
      disp->setNodeValue(v,Coord(0,0,0));
    }delete itN;
  }
  superGraph->getPropertyProxyContainer()->delLocalProxy("dispSpring");
  return pluginProgress->progress(100,100);
}

bool SpringElectrical::check(string &erreurMsg){
  erreurMsg="";
  return true;
}

void SpringElectrical::reset(){}









