#include <sys/timeb.h>
#include<qinputdialog.h>
#include <tulip/TulipPlugin.h>

using namespace std;

struct CompleteBinaryTree:public ImportModule
{
  CompleteBinaryTree(ClusterContext context):ImportModule(context)
  {}
  ~CompleteBinaryTree(){}
  void buildNode(node n,unsigned int degree,int depth)
  {
    if (depth<1) return;
    for (int i=0;i<degree;++i) {
      node n1=superGraph->addNode();
      superGraph->addEdge(n,n1);
      buildNode(n1,degree,depth - 1);
    }
  }
  bool import(const string &name)
  {
    bool ok=true;
    int resMin = QInputDialog::getInteger( QString("Please enter the depth of the tree"),QString("depth"), 0, 0, 1000000, 10, &ok );
    int degree = QInputDialog::getInteger( QString("Please enter the depth of the tree"),QString("degree"), 0, 0, 1000000, 10, &ok );
    if (!ok) return false;
    node n=superGraph->addNode();
    buildNode(n,degree,resMin);
    return true;
  }
};
IMPORTPLUGIN(CompleteBinaryTree,"Complete Tree","Auber","08/09/2002","0","0","1")
