#include <sys/timeb.h>
#include <qinputdialog.h>
#include <tulip/TulipPlugin.h>

using namespace std;

struct RandomTreeGeneral:public ImportModule
{
  RandomTreeGeneral(ClusterContext context):ImportModule(context)
  {}
  ~RandomTreeGeneral(){}
  bool buildNode(node n,int sizeM,int arityMax,int depth,int depthMax)
  {
    if (depth>depthMax) return true;
    if (superGraph->numberOfNodes()>sizeM) return true;
    bool result=true;
    int randNumber=rand();
    int i;
    if (randNumber<RAND_MAX/2) return true;
    i=randNumber%arityMax+1;
    for (;i>0;i--)
      {
	node n1;
	n1=superGraph->addNode();
	superGraph->addEdge(n,n1);
	result= result && buildNode(n1,sizeM,arityMax,depth+1,depthMax);
      }
    return result;
  }
  bool import(const string &name)
  {
    timeb tmp;
    ftime(&tmp);
    srand(tmp.time); 
    bool ok=true;

    int depthMax = QInputDialog::getInteger( QString("Please enter the maximum depth of the tree"),QString("Max Tree Depth"), 0, 0, 1000000, 10, &ok );
    if (!ok) return false;
    int sizeMin = QInputDialog::getInteger( QString("Please enter the minimum size of the tree"),QString("Min Tree Size"), 0, 0, 1000000, 10, &ok );
    if (!ok) return false;
    int sizeMax = QInputDialog::getInteger( QString("Please enter the maximum size of the tree"),QString("Max Tree Size"), 0, 0, 1000000, 10, &ok );
    if (!ok) return false;
    int arityMax = QInputDialog::getInteger( QString("Please enter the maximum size of the tree"),QString("Max Tree Arity"), 0, 0, 1000000, 10, &ok );
    if (!ok) return false;
    int i=0;
    while (ok)
      {
	if (!pluginProgress->progress(i%100,100)) return false;
	i++;
	Iterator<node> *it=superGraph->getNodes();
	while(it->hasNext()) superGraph->delNode(it->next());
	delete it;
	
	node n=superGraph->addNode();
	ok=!buildNode(n,sizeMax,arityMax,0,depthMax);
	ok=false;
	if (superGraph->numberOfNodes()<sizeMin) ok=true;

      }
    return true;
  }
};
IMPORTPLUGIN(RandomTreeGeneral,"Random General Tree","Auber","16/02/2001","0","0","1")
