/****************************************************************/
/*								*/
/*		AdjacencyMatrixImport.cpp			*/
/*	Reads in graph given by the Adjacency Matrix.		*/
/*	Expected input is <Input>=<Size>,<Size><Matrix>		*/
/*	Where <Size> is a positive number, 			*/
/*	and <Matrix> is a <size>x<size> 0-1 matrix.		*/
/*	The delimeters between the numbers can be any white	*/
/*	space. Any remaining data in the file is ignored.	*/
/*	If there is no enough tokens to generate the graph	*/
/*	an exception is generated.				*/
/*								*/
/*	Written by Vakhid Masagutov.				*/
/*	September 25, 2001					*/
/*								*/
/****************************************************************/

#include <fstream>
#include <math.h>
#include <tulip/TulipPlugin.h>

using namespace std;

struct AdjacencyMatrixImport:public ImportModule
{
  AdjacencyMatrixImport(ClusterContext context):ImportModule(context){
    addParameter<string>("filename");
  }
  ~AdjacencyMatrixImport(){}

  bool import(const string &name)
  {
    std::ifstream in(name.c_str());
    unsigned int size=0,size1=0;
    string v;
    char ch;
    in>>size>>ch>>size1;
		
    //some error checking
    if (size==0)
      {
	std::cerr<<"****\n**** File "<<name
		 <<":\n**** size of the graph cannot be zero.\n"
		 <<"****\n";
	return false;
      }
    if (size!=size1)
      {
	std::cerr<<"****\n**** File "<<name
		 <<":\n**** the input must be a square matrix.\n"
		 <<"****\n";
	return false;
      }

    //create nodes
    node *nodes=new node[size];
    for (unsigned int i=0;i<size;i++)
      nodes[i]=superGraph->addNode();
    StringProxy *labels=getLocalProxy<StringProxy>(superGraph,"viewLabel");

    //create edges
    for (unsigned int i=0;i<size;i++)
      {
	unsigned int j;
	for (j=0;j<size &&in>>v;j++)
	  {
				//the following is going to ignore multiple
				//edges. Do we need them?
	    if (j==i) 
	      labels->setNodeValue(nodes[i],v.c_str());
	    else
	      if (v!="0") 
		superGraph->addEdge(nodes[i],nodes[j]);
	  }
	if (j!=size)
	  {
	    std::cerr<<"****\n**** File "<<name
		     <<":\n**** incorrect format.\n****\n";
	    delete[] nodes;
	    return false;
	  }
      }
    delete[] nodes;

    //Do more error/warning checking
    char x;
    if (in>>x)
      std::cerr<<"****\n**** File "<<name
	       <<"**** Trailing characters.\n"
	       <<"**** Possibly incorrect format.\n"
	       <<"****\n";
    return true;
  }

};

IMPORTPLUGIN(AdjacencyMatrixImport,"Adjacency Matrix","Vakhid", "9/25/2001","0","0","1")

