#include "ConvolutionClusteringSetup.h"
#include <iostream>
#include <qpainter.h>
#include <qpaintdevice.h>
#include <vector>
#include <cstdlib>
#include <qslider.h>
#include <cmath>

using namespace std;
/* 
 *  Constructs a ConvolutionClusteringSetup which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
ConvolutionClusteringSetup::ConvolutionClusteringSetup( ConvolutionClustering *convolPlugin,QWidget* parent,  const char* name, bool modal, WFlags fl )
  : ConvolutionClusteringSetupData( parent, name, modal, fl ), convolPlugin(convolPlugin),useLogarithmicScale(false)
{
  int a,b,c;
  convolPlugin->getParameters(a,b,c);
  widthSlider->setMinValue(1);
  widthSlider->setMaxValue(a);
  widthSlider->setValue(c);
  discretizationSlider->setMinValue(1);
  discretizationSlider->setMaxValue(2*a);
  discretizationSlider->setValue(a);
  thresholdSlider->setValue(b);
  cerr << "disc=" << a << " thres="<<b << " width=" << c << endl;
}

/*  
 *  Destroys the object and frees any allocated resources
 */
ConvolutionClusteringSetup::~ConvolutionClusteringSetup()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * public slot
 */
void ConvolutionClusteringSetup::setlog(bool b) 
{
  useLogarithmicScale=b;
  update();
}
void ConvolutionClusteringSetup::update()
{
  convolPlugin->setParameters(discretizationSlider->value(),thresholdSlider->value(),widthSlider->value());
  paintEvent(0);
}

void ConvolutionClusteringSetup::paintEvent( QPaintEvent * )
{
  QPainter *p=new QPainter( (QWidget *)Frame3 );
  vector<double> &histogram=*(convolPlugin->getHistogram());
  double threshold=thresholdSlider->value();
  if (histogram.size()<1) reject();

  double maxHistogram,minHistogram;
  double max;
  //compute min max of the histogram
  if (!useLogarithmicScale) {
    max=maxHistogram=histogram[0];
    minHistogram=histogram[0];
  }
  else {
    maxHistogram=log10(histogram[0]+1);
    minHistogram=log10(histogram[0]+1);
  }
  for (unsigned int i=1;i<histogram.size();++i) {
    if (!useLogarithmicScale) {
      if (histogram[i]>max) max=histogram[i];
      if (histogram[i]>maxHistogram) maxHistogram=histogram[i];
      if (histogram[i]<maxHistogram) minHistogram=histogram[i];
    }
    else {
      if (histogram[i]>max) max=histogram[i];
      if (log10(histogram[i]+1)>maxHistogram) maxHistogram=log10(histogram[i]+1);
      if (log10(histogram[i]+1)<maxHistogram) minHistogram=log10(histogram[i]+1);
    }
  }

  thresholdSlider->setMaxValue((int)max);  

  //compute axis position
  QFont f( "times", 12, QFont::Bold );
  p->setFont( f );
  p->setPen( Qt::black );

  //les 20 de plus permetront de placer des lgendes sur les axes.
  double scale=(double)histogram.size()/64;
  int legendWidth=(int)(20*scale);
  int borderWidth=(int)(10*scale);
  int axisWidth=(int)(15*scale);
  p->setWindow( 0, 0,2*histogram.size()+legendWidth , histogram.size()+legendWidth );		// defines coordinate system
  p->fillRect(0,0,2*histogram.size()+legendWidth , histogram.size()+legendWidth , QBrush(QColor(255,255,255)));
  // draw bars
  QColor c;

  double histoScale=(double)histogram.size()/(double)maxHistogram;

  for (unsigned int i=0; i<histogram.size(); i++ ) {	
    c.setHsv( (int) ((double)i*360.0/(double)histogram.size()) , 255, 255 );
    p->setBrush( c );
    if (!useLogarithmicScale)
      p->drawRect( borderWidth+i*2, 
		   borderWidth+1+histogram.size()- (int)((double)histogram[i]*histoScale) , 
		   2 ,
		   (int)((double)histogram[i]*histoScale ));
    else
      p->drawRect( borderWidth+i*2, 
		   borderWidth+1+histogram.size()- (int)(log10(1+(double)histogram[i])*histoScale) , 
		   2 ,
		   (int)(log10(1+(double)histogram[i])*histoScale ));
  }

  //draw axis
  p->drawLine(borderWidth,borderWidth,borderWidth,histogram.size()+borderWidth);
  p->drawLine(borderWidth,histogram.size()+borderWidth,2*histogram.size()+axisWidth,histogram.size()+borderWidth);
  c.setHsv( 359 , 255, 255 );

  //draw local minimum
  list<int> localMinimum=convolPlugin->getLocalMinimum();
  while (!localMinimum.empty()) {
    int i=localMinimum.front();
    localMinimum.pop_front();
    p->drawLine(borderWidth+i*2,borderWidth,borderWidth+i*2,histogram.size()+borderWidth);
  }

  /*
  if (!useLogarithmicScale) {
      if (threshold<maxHistogram && threshold>0) 
	p->drawLine(borderWidth,
		    borderWidth+1+histogram.size()- (int)((double)threshold*histoScale), 
		    axisWidth+2*histogram.size(),
		    borderWidth+1+histogram.size()- (int)((double)threshold*histoScale));
  }
  else
    if ((log10(threshold+1)<maxHistogram && threshold>0))
      p->drawLine(borderWidth,
		  borderWidth+1+histogram.size()- (int)(log10(1+(double)threshold)*histoScale),
		  axisWidth+2*histogram.size(),
		  borderWidth+1+histogram.size()- (int)(log10(1+(double)threshold)*histoScale));
  */
  //draw threshold
  delete p;
}

