#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "tulip/SuperGraphAbstract.h"
#include "tulip/SelectionProxy.h"

using namespace std;

int SuperGraph::maxId=0;

SuperGraphAbstract::SuperGraphAbstract(){}
SuperGraphAbstract::~SuperGraphAbstract(){}
//=========================================================================

node SuperGraphAbstract::getInNode(const node n,unsigned int i)const {
  assert(i <= indeg(n) && i>0);
  Iterator<node>*itN=getInNodes(n);
  node result;
  for(unsigned int j=i+1;j>1;--j){
    result=itN->next();
  }delete itN;
  return result;
}

node SuperGraphAbstract::getOutNode(const node n,unsigned int i)const {
  assert(i <= outdeg(n) && i>0);
  Iterator<node>*itN=getOutNodes(n);
  node result;
  for(unsigned int j=i+1;j>1;--j){
    result=itN->next();
  } delete itN;
  return result;
}

int SuperGraphAbstract::deg(const node n) const {
  int deg=0;
  Iterator<edge> *it=getInOutEdges(n);
  for (;it->hasNext();) {
    it->next();
    deg++;
  } delete it;
  return deg;
}

int SuperGraphAbstract::indeg(const node n) const {
  int deg=0;
  Iterator<edge> *it=getInEdges(n);
  for (;it->hasNext();) {
    it->next();
    deg++;
  } delete it;
  return deg;
}

int SuperGraphAbstract::outdeg(const node n) const {
  int deg=0;
  Iterator<edge> *it=getOutEdges(n);
  for (;it->hasNext();) {
    it->next();
    deg++;
  } delete it;
  return deg;
}
node SuperGraphAbstract::source(const edge e) const {
  return getFather()->source(e);
}
node SuperGraphAbstract::target(const edge e) const {
  return getFather()->target(e);
}
node SuperGraphAbstract::opposite(const edge e, const node n)const {
  return ( (source(e)==n) ? target(e):source(e) );
}
void SuperGraphAbstract::reverse(const edge e) {
  getFather()->reverse(e);
}
//=========================================================================
bool SuperGraphAbstract::isTree() { 
#ifndef NDEBUG
  cerr << "SuperGraphAbstract::isTree()" << endl;
#endif
  bool rootNodeFound=false;
  if (numberOfEdges()!=numberOfNodes()-1) return false;
  Iterator<node> *it=getNodes();
  for (;it->hasNext();) {
    node tmp=it->next();
    if (indeg(tmp)>1) {
      delete it;
      return false;
    }
    if (indeg(tmp)==0) {
      if (rootNodeFound) {
	delete it;
	return false;
      }
      else
	rootNodeFound=true;
    }
  }delete it;
  if (isAcyclic())
    return true;
  else
    return false;
}
//=========================================================================
bool  SuperGraphAbstract::acyclicTest(node n,SelectionProxy *visited,SelectionProxy *finished) {

  bool result=true;
  visited->setNodeValue(n,true);
  Iterator<node> *it=this->getOutNodes(n);
  for (;it->hasNext();)
    {
      node tmp=it->next();
      if ((visited->getNodeValue(tmp))==true) {
	if ((finished->getNodeValue(tmp))==false) {
	  delete it;
	  return false;
	}
      }
      else {
	result=result && acyclicTest(tmp,visited,finished);
	if (result==false) {
	  delete it;
	  return false;
	}
      }
    }
  delete it;
  finished->setNodeValue(n,true);
  return true;
}
bool SuperGraphAbstract::isAcyclic() {
#ifndef NDEBUG
  cerr << "SuperGraphAbstract::isAcyclic()" << endl;
#endif
  PropertyProxyContainer *pPC=this->getPropertyProxyContainer();
  SelectionProxy *visited=getLocalProxy<SelectionProxy>(this,"AcyclicTestVisited");
  SelectionProxy *finished=getLocalProxy<SelectionProxy>(this,"AcyclicTestFinished");
  visited->setAllNodeValue(false);
  finished->setAllNodeValue(false);
  bool result=true;
  Iterator<node> *it=this->getNodes();
  for (;it->hasNext();) {
    node curNode=it->next();
    if (!visited->getNodeValue(curNode)) {
      result = result && acyclicTest(curNode,visited,finished);
      if (!result) {
	pPC->delLocalProxy("AcyclicTestVisited");
	pPC->delLocalProxy("AcyclicTestFinished");
	delete it;
	return false;
      }
    }
  }
  delete it;
  pPC->delLocalProxy("AcyclicTestVisited");
  pPC->delLocalProxy("AcyclicTestFinished");
  return true;
}
//=========================================================================
int SuperGraphAbstract::numberOfNodes() const {
  int result=0;
  Iterator<node> *it=getNodes();
  for (;it->hasNext();) {
    it->next();
    result++;
  }
  delete it;
  return result;
}
//=========================================================================
int SuperGraphAbstract::numberOfEdges() const {
  int result=0;
  Iterator<edge> *it=getEdges();
  for (;it->hasNext();) {
    it->next();
    result++;
  }
  delete it;
  return result;
}
//=========================================================================
ostream & operator << (ostream &os,const SuperGraph *sp) {
  os << "Nodes :" << endl;
  Iterator<node> *itn=sp->getNodes();
  for (;itn->hasNext();) {
    os << itn->next().id;
    if (itn->hasNext()) os << ",";
  }delete itn; 
  os << endl << "Edges :" << endl;
  Iterator<edge> *ite=sp->getEdges();
  for (;ite->hasNext();) {
    edge e=ite->next();
    os << "(" << sp->source(e).id << "->" << sp->target(e).id << ")";
    if (ite->hasNext()) os << ",";
  }
  delete ite;
  os << endl;
  return os;
}




