//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "tulip/MethodFactory.h"
#include "tulip/SelectionProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/Selection.h"
#include "tulip/PropertyProxy.h"

using namespace std;

TemplateFactory<SelectionFactory,Selection,PropertyContext *> SelectionProxy::factory;
//=================================================================================
SelectionProxy::SelectionProxy (PropertyContext *context):PropertyProxy<BooleanType,BooleanType>(context)
{
  currentSelection=NULL;
  propertyProxy=this;
}
//=================================================================================
SelectionProxy::~SelectionProxy() {}  
//=================================================================================
bool SelectionProxy::select(string s,string &s2)
{
  Observable::holdObservers();
  context.superGraph=superGraph;
  context.propertyProxy=this;
  Selection *tmpSelection=factory.getObject(s,&context);
  bool   result;
  if (tmpSelection!=NULL)
    {
      result=tmpSelection->check(s2);
      if (currentSelection!=NULL) delete currentSelection;
      currentSelection=tmpSelection;
      changeCurrentProperty(currentSelection,s);
      if (result)
	{
	  reset();
	  currentSelection->run();
	}
    }
  else
    {
      s2="Data Selection enable";
      result=true;
    }
  notifyObservers();
  Observable::unholdObservers();
  return result;
}
//=============================================================================
///Poign permettnet le reset des variables du MetricProxy par le PropertyProxy
void SelectionProxy::reset_handler()
{

}
//=============================================================================
///Poign permettnet le recompute il faut absolument mettre le graphProperties
///currentMetricProxy  this sinon le rsultat est imprvisible
void SelectionProxy::recompute_handler()
{
  superGraph->getPropertyProxyContainer()->currentPropertyProxy=this;
}


//=================================================================================
//Fonctionnalit supplmentaire ajout au seletion Proxy
void SelectionProxy::reverse()
{
  Observable::holdObservers();
  Iterator<node> *itN=superGraph->getNodes();
  for (;itN->hasNext();)
    {
      node itn=itN->next();
      if (getNodeValue(itn)==true)
	setNodeValue(itn,false);
      else
	setNodeValue(itn,true);
    }
  delete itN;
  Iterator<edge> *itE=superGraph->getEdges();
  for (;itE->hasNext();)
    {
      edge ite=itE->next();
      if (getEdgeValue(ite)==true)
	setEdgeValue(ite,false);
      else
	setEdgeValue(ite,true);
    }
  delete itE;
  notifyObservers();
  Observable::unholdObservers();
}
//=================================================================================
void SelectionProxy::reverseEdgeDirection()
{
  Iterator<edge> *itE=superGraph->getEdges();
  for (;itE->hasNext();)
    {
      edge ite=itE->next();
      if (getEdgeValue(ite))
	superGraph->reverse(ite);
    }
  delete itE;
}











