/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify  *
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>
#include "tulip/PropertyProxyContainer.h"
#include "tulip/SuperGraph.h"
#include "tulip/PropertyProxy.h"

using namespace std;

//==============================================================
PropertyProxyContainerImpl::PropertyProxyContainerImpl(SuperGraph *spGr)
{
  superGraph=spGr;
  currentPropertyProxy=NULL;
}
//==============================================================
PropertyProxyContainerImpl::~PropertyProxyContainerImpl()
{
#ifndef NDEBUG
  cerr << "PropertyProxyContainerImpl::~PropertyProxyContainerImpl" << endl;
#endif
  map<string,PProxy*>::iterator itP;
  for (itP=propertyProxyMap.begin();itP!=propertyProxyMap.end();++itP)
    {
#ifndef NDEBUG
      cerr << " Delete " << (*itP).first << " PropertyProxy" << endl;
#endif
      delete (*itP).second;
    }
  propertyProxyMap.clear();
#ifndef NDEBUG
  cerr << "PropertyProxyContainerImpl::~PropertyProxyContainerImpl Ok......." << endl;
#endif
}
//==============================================================
bool PropertyProxyContainerImpl::existProxy(const string &str)
{
  if (existLocalProxy(str))
    return true;
  else
    {
      if (superGraph->getFather()==superGraph)
	{
	  return false;
	}
      else
	return (superGraph->getFather()->getPropertyProxyContainer()->existProxy(str));
    }
}
//==============================================================
bool PropertyProxyContainerImpl::existLocalProxy(const string &str)
{
  return (propertyProxyMap.find(str)!=propertyProxyMap.end());
}
//==============================================================
void PropertyProxyContainerImpl::setLocalProxy(const string &str, PProxy *p)
{
  //  cerr << "Get Local Proxy :" << str << endl;
  if (existLocalProxy(str))
    delete propertyProxyMap[str];
  propertyProxyMap[str]=p;
}
//==============================================================
PProxy* PropertyProxyContainerImpl::getProxy(const string &str)
{
  assert(existProxy(str));
  //  cerr << "Get Proxy :" << str << endl;
  if (existLocalProxy(str))
    return this->getLocalProxy(str);
  else
    {
      return (superGraph->getFather()->getPropertyProxyContainer()->getProxy(str));
    }
  return 0;
}
//==============================================================
PProxy* PropertyProxyContainerImpl::getLocalProxy(const string &str)
{
  assert(existLocalProxy(str));
  return (propertyProxyMap[str]);
}
//==============================================================
void PropertyProxyContainerImpl::delLocalProxy(const string &str)
{
  PProxy *tmpM;
  map<string,PProxy *>::iterator it;
  it=propertyProxyMap.find(str);
  if (it!=propertyProxyMap.end())
    {
      tmpM=(*it).second;
      propertyProxyMap.erase(it);
      delete tmpM;
    }
}
Iterator<string>*  PropertyProxyContainerImpl::getLocalProperties()
{
  return (new LocalPropertiesIterator(this));
}
Iterator<string>*  PropertyProxyContainerImpl::getInheritedProperties()
{
  return (new InheritedPropertiesIterator(this));
}
//==============================================================
void PropertyProxyContainerImpl::update()
{}
//===============================================================
LocalPropertiesIterator::LocalPropertiesIterator(PropertyProxyContainerImpl *ppc)
{
  this->ppc=ppc;
  it=ppc->propertyProxyMap.begin();
  itEnd=ppc->propertyProxyMap.end();
}
string LocalPropertiesIterator::next()
{
  string tmp=(*it).first;
  ++it;
  return tmp;
}
bool LocalPropertiesIterator::hasNext()
{
  return (it!=itEnd);
}
//===============================================================
InheritedPropertiesIterator::InheritedPropertiesIterator(PropertyProxyContainer *ppc)
{
  this->ppc=ppc; 
  if (ppc->superGraph->getFather()!=ppc->superGraph)
    {
      //Rcupration des proprites locale du pre.
      Iterator<string> *itS=ppc->superGraph->getFather()->getPropertyProxyContainer()->getLocalProperties();
      for (;itS->hasNext();)
	{
	  string tmp=itS->next();
	  if (!ppc->existLocalProxy(tmp))
	    {
	      inhList.insert(tmp);
	    }
	}
      delete itS;
      //Rcupration des proprites hrites du pre.
      itS=ppc->superGraph->getFather()->getPropertyProxyContainer()->getInheritedProperties();
      for (;itS->hasNext();)
	{
	  string tmp=itS->next();
	  if (!ppc->existLocalProxy(tmp))
	    {
	      inhList.insert(tmp);
	    }
	}
      delete itS;  
    }
  it=inhList.begin();
  itEnd=inhList.end();
}
string InheritedPropertiesIterator::next()
{
  string tmp=(*it);
  ++it;
  return tmp;
}
bool InheritedPropertiesIterator::hasNext()
{
  return (it!=itEnd);
}
//===============================================================
void PropertyProxyContainerImpl::erase(const node n)
{
  map<string,PProxy*>::iterator itP;
  for (itP=propertyProxyMap.begin();itP!=propertyProxyMap.end();++itP)
    {
      itP->second->erase(n);
    }
}
//===============================================================
void PropertyProxyContainerImpl::erase(const edge e)
{
  map<string,PProxy*>::iterator itP;
  for (itP=propertyProxyMap.begin();itP!=propertyProxyMap.end();++itP)
    {
      itP->second->erase(e);
    }
}
