#ifndef TULIPCONF_H
#define TULIPCONF_H

#if (__GNUC__ < 3)
#  define STL_EXT_NS std
#  define _DEPRECATED
#  include <stl_hash_fun.h>
#else
#  define STL_EXT_NS __gnu_cxx
#  define _DEPRECATED __attribute__ ((deprecated))
#  include <ext/stl_hash_fun.h>
#endif

#include <string>

namespace STL_EXT_NS {
  template<> struct hash<const std::string>{
    size_t operator()(const std::string &s) const {return hash<const char *>()(s.c_str()); }
  };
  template<> struct hash<std::string>{
    size_t operator()(const std::string &s) const {return hash<const char *>()(s.c_str()); }
  };
}

#endif //TULIPCONF_H
