//-*-c++-*-
#ifndef _TLPTOOLS_H
#define _TLPTOOLS_H

#include <iostream>

#include "SuperGraph.h"
#include "LayoutProxy.h"
#include "MetricProxy.h"
#include "StringProxy.h"
#include "SelectionProxy.h"
#include "ColorsProxy.h"
#include "IntProxy.h"
#include "SizesProxy.h"
#include "PluginProgress.h"
#include "Reflect.h"

namespace TlpTools {
  extern std::string TulipLibDir;
  extern std::string TulipPluginsPath;
  
  extern void initTulipLib();
    
  extern TemplateFactory<ClusteringFactory,Clustering,ClusterContext > clusteringFactory;
  extern TemplateFactory<ImportModuleFactory,ImportModule,ClusterContext > importFactory;
  extern TemplateFactory<ExportModuleFactory,ExportModule,ClusterContext > exportFactory;
  void loadPlugins(PluginLoader *plug=0);

  SuperGraph * importGraph(const std::string &alg, DataSet &dataSet, PluginProgress *plugProgress=NULL);
  bool exportGraph(SuperGraph *sg,std::ostream  &os,const std::string &alg, DataSet &dataSet, PluginProgress *plugProgress=0);
  bool clusterizeGraph(SuperGraph *sg,std::string &errorMsg, DataSet *dataSet =0,const std::string &alg="hierarchical" , PluginProgress *plugProgress=0);
  /**
   * Return a new graph
   */
  SuperGraph* newSuperGraph();
  /**
   *  Return an empty subgraph 
   */
  SuperGraph *newSubGraph(SuperGraph *, std::string name = "unnamed");
  /**
   *  Return a subgraph induced by a set of nodes
   */
  SuperGraph *inducedSubGraph(SuperGraph *, const std::set<node> &, std::string name = "induced subgraph");
  /**
   *  Return a subgraph equal to the graph given in parameter (a clone subgraph)
   */
  SuperGraph *newCloneSubGraph(SuperGraph *, std::string name = "unnamed");

  /**
   * Return an istream from a gzipped file (uses gzstream lib)
   * the stream has to be deleted after use.
   * \warning Don't forget to check the stream with ios::bad()!
   */
  std::istream *getIgzstream(const char *name, int open_mode = std::ios::in);
  /**
   * Return an ostream to write to a gzipped file (uses gzstream lib)
   * the stream has to be deleted after use.
   * \warning Don't forget to check the stream with ios::bad()!
   */
  std::ostream *getOgzstream(const char *name, int open_mode = std::ios::out);
};

#endif
