//-*-c++-*-

/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifndef Tulip_SUPERGRAPHVIEW_H
#define Tulip_SUPERGRAPHVIEW_H

#include "SuperGraphAbstract.h"

/**
   This class is one the implementation of the SuperGraph Interface
   It only filters the elements of its parents.
*/
class SuperGraphView:public SuperGraphAbstract
{
 private:
  SuperGraph *_superGraph;
  SubGraph *_currentView;
  PropertyProxyContainer *_propertiesProxyContainer;
  mutable int nNodes;
  mutable int nEdges;
 public:
  SuperGraphView(SuperGraph *superGraph,SubGraph *subGraph);
  ~SuperGraphView();
  //=========================================================================
  ///
  PropertyProxyContainer *getPropertyProxyContainer();
  ///
  SuperGraph *getFather()const;
  ///
  Cluster *getClusterTree();
  ///
  SubGraph* getSubGraph();
  //=========================================================================
  ///
  SuperGraph *getView(SubGraph *subGraph);
  ///
  SubGraph *addView(const std::string &name,SelectionProxy *selectionProxy);
  ///
  void delView(SubGraph *view);
  ///
  void delAllView(SubGraph *view);
  //=========================================================================
  /** Return true if the node is element of the graph*/
  bool isElement(const node );
  /** Return true if the edge is element of the graph*/
  bool isElement(const edge );
  ///
  node addNode();
  ///
  edge addEdge(const node n1,const node n2);
  ///
  void addNode(const node);
  ///
  void addEdge(const edge);
  ///
  void delNode(const node);
  ///
  void delEdge(const edge);
  ///
  void delAllNode(const node);
  ///
  void delAllEdge(const edge);
  ///
  int numberOfNodes()const;
  ///
  int numberOfEdges()const;
  //=========================================================================
  ///
  Iterator<node>* getNodes()const;
  ///
  Iterator<node>* getInNodes(const node)const;
  ///
  Iterator<node>* getOutNodes(const node)const;
  ///
  Iterator<node>* getInOutNodes(const node)const;
  ///
  Iterator<edge>* getEdges()const;
  ///
  Iterator<edge>* getInEdges(const node)const;
  ///
  Iterator<edge>* getOutEdges(const node)const;
  ///
  Iterator<edge>* getInOutEdges(const node)const;
  //=========================================================================
};

#endif



