//-*-c++-*-
#ifndef TULIP_STRINGPROXY_H
#define TULIP_STRINGPROXY_H

#include "PropertyProxy.h"
#include "MethodFactory.h"
#include "TemplateFactory.h"

class PropertyContext;

///
class StringProxy:public PropertyProxy<StringType,StringType>
{ 
  ///
  friend class String;

public:
  ///
  static TemplateFactory<StringFactory,String,PropertyContext *> factory;

private:
  ///
  String *currentString;

public :
  ///
  StringProxy (PropertyContext *context);
  ///
  ~StringProxy();
  ///
  void reset();
  ///
  bool select(std::string , std::string &);
  ///
  void reset_handler();
  ///
  void recompute_handler();  
};

#endif
