//-*-c++-*-

/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify  *
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#ifndef TULIP_PROPERTY_H
#define TULIP_PROPERTY_H

#include "PluginContext.h"
#include "SuperGraph.h"
#include "Reflect.h"
#include "WithParameter.h"

class PropertyProxyContainer;

class PProperty:public WithParameter{
public:
  ///
  virtual ~PProperty(){}
  ///
  virtual bool run() = 0;
  ///
  virtual bool check(std::string &) = 0;
  ///
  virtual void reset() = 0;
};


///
template <typename Tnode, typename Tedge> class Property:public PProperty
{
public :
  ///
  Property(PropertyContext *context) {
    if (context != NULL) {
      superGraph = context->superGraph;
      propertyProxy = context->propertyProxy;
      pluginProgress = context->pluginProgress;
      dataSet= context->dataSet;
    }
    else
      (void *)dataSet=(void *)superGraph = (void *)propertyProxy = (void *)pluginProgress = (void *)NULL;

  }
  ///
  virtual ~Property(){}
  ///
  virtual typename Tnode::RealType getNodeValue(const node ) 
    //  {return ((PropertyProxy< typename Tnode , typename Tedge > *)propertyProxy)->getNodeDefaultValue();}
  {return Tnode::defaultValue();}
  ///
  virtual typename Tedge::RealType getEdgeValue(const edge ) {return Tedge::defaultValue();}
  //  {return ((PropertyProxy< typename Tnode , typename Tedge > *)propertyProxy)->getEdgeDefaultValue();}
  ///
  bool run() {return true;}
  ///
  bool check(std::string &) {return true;}
  ///
  void reset() {}


protected:
  ///
  SuperGraph *superGraph;
  ///
  PProxy *propertyProxy;
  ///
  PluginProgress *pluginProgress;
  ///
  DataSet *dataSet;
};

#endif
